<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="description" content="{{ $_setting->description }}" />
    <meta name="author" content="{{ $_setting->title }}" />
    <title>{{ localize('Not Found') }} - {{ $_setting->title }}</title>
    <!-- App favicon -->
    <link rel="shortcut icon"
        href="{{ $_setting->favicon ? storage_asset($_setting->favicon) : assets('img/favicon.png') }}">

    <link href="{{ assets('vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet" />

    <!--Start Your Custom Style Now-->
    <link href="{{ assets('css/extra.css?v=1.0') }}" rel="stylesheet" />
    <link href="{{ assets('css/style-new.css?v=1.0') }}" rel="stylesheet" />
    <style>
        .eyes {
            display: flex;
            justify-content: center;
            gap: 2px;
        }

        .eye {
            width: 80px;
            height: 80px;
            background-color: #ff6767;
            border-radius: 50%;
            display: grid;
            place-items: center;
        }

        .eye__pupil {
            width: 30px;
            height: 30px;
            background-color: #000;
            border-radius: 50%;
            animation: movePupil 2s infinite ease-in-out;
            transform-origin: center center;
        }

        @keyframes movePupil {

            0%,
            100% {
                transform: translate(0, 0);
            }

            25% {
                transform: translate(-10px, -10px);
            }

            50% {
                transform: translate(10px, 10px);
            }

            75% {
                transform: translate(-10px, 10px);
            }
        }

        .animate-text {
            background-image: linear-gradient(-225deg, #dc3b00 0%, #be401a 29%, #0143ea 67%, #f2ff00 100%);
            background-size: auto auto;
            background-clip: border-box;
            background-size: 200% auto;
            color: #fff;
            font-size: 50px;
            font-weight: 600;
            background-clip: text;
            text-fill-color: transparent;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            animation: textanim 2s linear infinite;
            display: inline-block;
        }

        @keyframes textanim {
            to {
                background-position: 200% center;
            }
        }
    </style>
</head>

<body class="bg-white">
    <div class="d-flex align-items-center justify-content-center text-center h-100vh">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="eyes">
                        <div class="eye">
                            <div class="eye__pupil eye__pupil--left"></div>
                        </div>
                        <div class="eye">
                            <div class="eye__pupil eye__pupil--right"></div>
                        </div>
                    </div>

                    <div class="cont" id="fore-particles">
                        <svg class="moko-404" viewbox="0 0 500 400">
                            <path d="M70 373.3l18.2-214L157 5.3h7.7L97.2 160.7l7 213.4" class="moko-404__d" />
                            <path
                                d="M90.2 185.8l-28-63.6-5.6-54.6L60 67l10 56.6 23 33.6m288.2 210.6l23-205 3-78.3 9-2 2 85.2L431 375.5"
                                class="moko-404__d" />
                            <path
                                d="M402.2 213.8l-23-61.6 6.3-45.2-4.2-1.4-7.8 44 12 100.6m70 126l2.8-206h4.2l11 205.2M333 369.8L343.5 22l4.2-.6 1.4 347M210 239L181 177.2l23.8-121-5.6 1.4L175 176l23 121"
                                class="moko-404__d" />
                            <ellipse cx="255.3" cy="379.2" class="moko-404__d" rx="228" ry="15" />
                            <path
                                d="M357.6 374.4a7.6 7.6 0 0 1-1.3-5.3 4 4 0 0 1-5.3 1.6h-.2c-3.6-2.2-3.4-3.5-3.4-3.5s-1 4.2-4.3 4.5c-2.5.2-4.2-.7-5.5-4.2 0 0 .2 3.6-3.3 3-2.6-.3-3.5-4.4-3.5-4.4s-1.7 4.3-3 4.2c0 0-1.6 1-2.3-1.8 0 0-2.6 2-.4 5.8m131 1.8c-2.3-4 .3-5.8.3-5.8.7 2.8 2.3 1.8 2.3 1.8 1.3 0 3-4.3 3-4.3s1 4 3.6 4.4c3.5.6 3.4-3 3.4-3 1.3 3.4 3 4.3 5.6 4l-.2 2.6"
                                class="moko-404__e" />
                            <ellipse cx="182" cy="378.8" class="moko-404__e" rx="7.1" ry="1.1" />
                            <ellipse cx="299.2" cy="372.8" class="moko-404__e" rx="3.9" ry="1.1" />
                            <ellipse cx="384.1" cy="379.6" class="moko-404__e" rx="3.9" ry="1.1" />
                            <ellipse cx="129" cy="384.3" class="moko-404__e" rx="3.9" ry="1.1" />
                            <ellipse cx="283" cy="385.1" class="moko-404__e" rx="3.1" ry=".8" />
                            <path
                                d="M287 210l40.4-134s8.4-5.6 7-1.4-40 138.5-40 138.5M50 337l-.5-79.6L54 256l2.6 80.4m152 5.4l-23-150.4-3 1.3 16.8 145.6m156.3-4.3l-9.5-77.3-6-1.3 6 79.3"
                                class="moko-404__f" />
                            <path d="M348.6 291.2L365 268l2.3-33.5 3.8-1.6-.7 36.4-17 53.6" class="moko-404__f" />
                            <path
                                d="M95.2 286H95a1.7 1.7 0 0 1-.4.4c.3-.2.7-.4.5-.5zm16.7-31a.3.3 0 0 0 0-.3v.2zm40 49.4zm2.7-44v-1.8a17.7 17.7 0 0 1 0 2s0-.5 0 0zM227 273v.7h.3l-.4-1m0-1.7l.4.5a19 19 0 0 1 0-4c-.8.6 0 2.3-.3 3.3zm1.8-5.8v-.2a3 3 0 0 1 0-.6v.7zm0-.2c0 .7.3-.3 0 0zm.6-2.7c0-1-.2-.7-.5-.3v.8c.2-.2.3-1 .4-.6zm-1-1l.2.3v-.5zm.2.7c-.2 0 0 0 0 .5v-1c-.2.2-.4.2 0 .5zm-.5 1.2c0 1.6.5 1.4.6-.2-.2.5-.3 1-.5.3zm-1.4 3.8l-.2.6.2.5c0-.2.3-1 0-1zm3-10l-.5.3.2.6c0-.4.3-1 .5-1zm-.5.3v-1 1zM228 261l.4 1.5-.4-1.8v.3m2.6-7l-.4-1v.5l.4.5m.6-2.8a5.4 5.4 0 0 0-.2-1.7 3.4 3.4 0 0 1-.4 1.7c.2.4.5-.5.6 0zm-.2-1.7a3 3 0 0 0 0-1 5.5 5.5 0 0 0 0 1zm-1 4.5l-.5.3v.3a1 1 0 0 0 .4-.7zm-.5.3v-.8zm0 .3zm-1.7 3.3c.3.3.5-.3.8.5-.2-.6-.4-1.7-.8-.7zm1.3-1.8l-.3-1-.2 1c0-.2.3-.4.4 0zm-.4-1.6v.5l.2-.3-.2-.2m1.4-4.5a3.8 3.8 0 0 1 0-1.4 9.4 9.4 0 0 0-.4 1.6s.3.3.4-.2zm-.4 2zM229.6 250.2a1.3 1.3 0 0 0 0 1 8.3 8.3 0 0 1 0-1zm1.2-3.3a4.6 4.6 0 0 0-.4.6c0-.2.4-.6.3-.7zm-1 4.6z"
                                class="moko-404__g" />
                            <path
                                d="M229.7 252.3a2.6 2.6 0 0 0 0-.6 4.5 4.5 0 0 0-.2.7.6.6 0 0 1 .2 0zm.8-6.3v.4a3.7 3.7 0 0 1 .8-1.2c0-.7 0-.8-.2-1l-.4 2zm-1.2 1.3c-.2 1 .2.8.2 1.5.3-1.8 0 .6.6-.7a7.5 7.5 0 0 1 0 1c0-.2 0-.5.2-.8 0-.6 0 0 0 0l.3-1.8a9 9 0 0 0-.4 1.7c-.2-.2-.2-1.2-.7-.7zm-2.5 10c0-.2 0-.2 0 0zm.6 0v-.2a4.7 4.7 0 0 1 .8-1.3 2.8 2.8 0 0 0-1 .7 1 1 0 0 1 0 .8c0 .4 0 0-.3 0 0 .3 0 1 .4.2zm.7-1.6h.2zm.5-3.6v-1.4l-.5.7h.3c0 1 0 .7.3.8zm2.8-8l.4.4-.4-1v.7m.7-2.2l-.3.4h.3v-.4m31-1.7l.4-.2a2.3 2.3 0 0 1-.3-1c0 .7-.3 1.5 0 1.3zm-20.4-12.3a9 9 0 0 0 1.2 0c-.6-.2-1.2-.4-1.3 0zm2.7-.4h-.3a8 8 0 0 1-1.2.3 1.8 1.8 0 0 0 1.4-.3zm-10.7 7.8c-.2.5 0 .2 0 0zm-2.3 1a.3.3 0 0 1 0 .2zm2-.5a3.2 3.2 0 0 0 .2-.3 3.3 3.3 0 0 0-.4.3zm0 0a3.4 3.4 0 0 0 0 .3v-.2zm.3-.4l.2-.4a3.6 3.6 0 0 1-.4.5zm-1.6 4l.2-1a2 2 0 0 1-.4.6s.3 0 .2.2zm-1.7 0c-.4 0-.5.7-.6 1.3.5.2.5-.5.6-1.2zm-.6 1.5a3.3 3.3 0 0 1-.2.5c.2.2 0 0 .2-.5zm4.4-6.2c.3.5.6-2 0-.5-.3.3.3.5 0 .5zm-5 5h.4l-.3-.6-.2.6m2.4-4.6l-.6 1v.3c.3-.5.7-1 .6-1.2zm-.6 1.2a2 2 0 0 0-.3.7 4.5 4.5 0 0 0 .2-.8zm9.2-9.7c0-.2-.3 0-.7 0 0 .4-.5.6-.3.7zm71.2 24v-.4l-.2-1.3c-.2.5-.4-1.3.2 1.5zm0-.4c.2 1.2 0-1 0 0zm-.6-5.6c-.5-1.7-.5-1.3-.6-.3l.5 1.8c0-.3-.2-1.8 0-1.3zm-1.4-1.7l.3 1c0-.2 0-.4-.3-1zm.8 2.7l-.5-1.8c0 .3-.3.4.2 1-.2-.2 0 0 .3 1zm0 1c0 1 .2 2.3-.3.7.6 3.3 1 2.8.4-.4zM297.4 209v.2-.2m4.3 7.4a4 4 0 0 0-.5-1.5c.3.4.4.8.6 1.4zm-2.2-3.8l-.2-.2.4.7a26.4 26.4 0 0 1-1-2.6l-1.3-1.3 1 1.8a12.2 12.2 0 0 1 1 1.8zm-2.2-4h.6l-.8-.6-.8-.6.5.5zm-2-3.5l-.5-.3-.4-.4.4.8zM203 199c-1.2.7-2.7 1.5-2.3 1.7h.6a11 11 0 0 1 1.6-1.8zm55.7-15.3a23 23 0 0 0-3-.6c1.5.4 2.6.8 3 .6zm-6.3-1l.6.2a15.3 15.3 0 0 1 2.8 0 7.4 7.4 0 0 0-3.4-.2zM283 193c.6.5 0 0 0 0zm1 1l-1-.8.8.8zm-.2-.3l.6.5s0-.2-.6-.6zm-1-.7l-1-.8 1.2 1-.2-.2zm7 6s-.2-.4 0-.2l-1.2-1.2a7.5 7.5 0 0 1 1 1.3zm0-.2h.2zm-9.6-7.2c.5.4.6-.2 1 0 .7 0-4-1.7-1 0zm161 86.8v1a19.8 19.8 0 0 1 .3-3.2l-.4-2v4.5zm.2-4.8l.4.4-.6-2v1.5m0-4.6h.4l-.2-1-.2 1m-33-84.3l-2.2-.5h-1.2l.7.5a12.6 12.6 0 0 1 2.5 0zm-44.6 62.7l.2-1-.6 1.4zm78-25.8v-3.2c-.2 1.6-.5 3-.2 3.3zm0-3.2a10.8 10.8 0 0 0 0-3.8v.7l.2 3zm.2 33.4v-1.2 1.3zm.2-1.4v0zm0 10v-2a9 9 0 0 1-.2 2s.2-.3.2 0zm0 0zm-.4-13c0 .6.5.3.3.7.4 1-.6-4.6-.3-.7zM153 284.5c.4-.3 1-.7.5-.7h-.4a.8.8 0 0 1 0 .7zm-.2 16a2.2 2.2 0 0 0 .2-1c-.3.5-.6.8-.3 1zM155 250l-.3-.2c0 .3 0 .3.2.3zm-2 49a2 2 0 0 1 0 .8.7.7 0 0 0 0-1zm0-106a2.6 2.6 0 0 1 0 .4.8.8 0 0 0 0-.4zm.6-1.8l.2-.4-.4.3v.3m0-1l-.6-.3v.4z"
                                class="moko-404__g" />
                            <path
                                d="M40.6 295.6l-.7 1 24.6-1.8 30.2-9.6c.5 0 .3-.8.8-1 0-.2.6-1.3.4-1.7a2 2 0 0 0 .4-.7h.4v-1c.3-.2.5-.3.5.2l.4-2v.2c.2-.3.3-1 .5-1 .6-.5 1.8-3.2 3-4.7-.7 0 .6-.7.3-1 .2 0 .3-.3.3 0 .3-.8 1-1 1-2v.3l.2-.4v.3a1.2 1.2 0 0 0 0-1.5 1 1 0 0 0 .3-1c.2 0 .4-.3.2.2.2-.3 1.2-1.8 1-2a1 1 0 0 0 0-.5l1-1.5h-.3c-.2-.4.2-.5.5-1 1-1.2.2-.7 1-1.8-.5-.4.7-1 1-1.8h-.3c0-.4 1-.7 1.4-1v.2c.7-1-.3-.3 0-1 .3-.2.3.2.6-.3.2-.3.4-2 1-2.4-.2 0-.4 0-.3-.3a5.6 5.6 0 0 1 .8-1c.3-.2.3-.2.2-.6l.5-1.5c0 .6.2 0 .5-.5s.5-1.4.2-.2l.4-.8v.3l.3-.6a3 3 0 0 1-.3.5c-.2 1.2-.2 1 .2 1l-.4.4v.8a1.8 1.8 0 0 0 0 1h-.2a2.8 2.8 0 0 1 0 1l-.2 1c0 1-.2 1.5.2 1.8l.2 1c0-1.3.4.2.5-.3 0 .5-.2 1.3-.2.7-.4-.3-.2 1.5-.5 1.4 0 2.5-.4 5-.5 7.3l.3-.2v.8c0 .2-.2.3 0-.3a1 1 0 0 0 0 1c0 1.2-.3-.4-.3 0v.3a2 2 0 0 1 .2 1.2c-.2.4-.3.2-.3.4v1.3l.2-.4c0 .6 0 1 .2.6-.5.7-.3 4-.4 4.3a6.3 6.3 0 0 1 0 2c0-.2.5-.3.4.4-.6-.3-.3 1.2-.8 1.7.3-.4 0 2 .4 1.2 0 .6-.3 0-.4.4.2 1.4-.3 3-.2 4.7 0 0 .2-.2.3 0l-.5 1c0 .3.4.3 0 1 0-.2.2-.3.3 0-.4 2.3 0 4.8-.3 7.3l36.4-.5-.5 11.8h9l.4-5h-4v-.2a1.8 1.8 0 0 1 .5 0c.8-.2-.6-.2 1.2-.4l-2 .2c0-.2-.3-.4 0-.2l-.2-.4v-.7c0-1-.6-2 0-3.3a2.5 2.5 0 0 1 0-1.4h.4c0-.6.4-1.5 0-1.7 1-.5.3-2.2.4-3h-.4a5.8 5.8 0 0 0-.3-2v-.2a11.5 11.5 0 0 0 0-2 2.3 2.3 0 0 0 0-.3.5.5 0 0 1 0 .6c1-1-.7-2.4 0-3.4a.6.6 0 0 1 0-.6l.2-.5a1.2 1.2 0 0 0-.2.4 3 3 0 0 0-.2-.8h.4c.2-.4-.2-.4-.5-.2a1.4 1.4 0 0 0-.3-.4c.7-.2-.3-.8.5-1-.4-.3-.4-1-.8-1.5v-1h.3l-.4-.5v-.7c.3 0 .4 0 .7.2a3.5 3.5 0 0 1-.5-1 9 9 0 0 1 .2-1.5c0-.6 1-.7 1-1a10.3 10.3 0 0 0 0-1.2v.2-.5a9.7 9.7 0 0 1 .3-3c-1 .3.5-.8-.4-1 .3 0 .4-.3.6 0-.4-1 1.3-1.4.6-2 .3 0-.6.2-.5 0l1-.3.3.3c0-1-.8-1-1.5-1a3.7 3.7 0 0 0 0-.5.4.4 0 0 0 0-.2 5.5 5.5 0 0 1 0-.6c.2-.6.4-1.8-.4-1.8 1 0 .3-.4.2-.5a.4.4 0 0 1 0-.4l-.2-1.3c0-1 .2-2 0-2h.2v-.3a4 4 0 0 1 .3-.6h-.2a18.5 18.5 0 0 0 0-2.4c.5-.3 1-.6 1-1s.2.2.3.4c.7-1-.5-.2-.6-1 .3-.2.8.2 1-.4 0-.3-1-1.6-.5-2.4-.4.2-.6.4-.8 0 0-.6 1-1.6.2-2a.3.3 0 0 1 .2-.2 7.7 7.7 0 0 0-1.8-1.8h.2c0 .3 0 0 0 0 1-.7-1-2.8.4-2.8v-1a1.5 1.5 0 0 0-.5-1.5c0-.2 0 0 .2 0 .3-.8-.8-1.7-1.3-2.3v-.3h.2c-.3-.4.7-2 .2-3.3a.3.3 0 0 1 .2 0c-.5-1.3 1.3-3.3-.4-3.8l-.4-1a1.5 1.5 0 0 1 0 .4v-.7c0-.4 0-1.4.4-1.4 0-2.5.5-4.8.5-7l-.7.2v-.8c0-.2.5-.3.5.3.4-.3-.3-1-.5-1 .3-1 .8.4.8 0v-.3c-.3-.4-.6-.4-.5-1 0-.5.4-.3.4-.5v-1.4l-.3.4c-.3-.4-.3-1-.3-.5a17 17 0 0 1 .5-4 3 3 0 0 1-.4-2 .5.5 0 0 1-.4 0v-.4c1 0 .3-1 1.2-1.6-.6.5-.2-1.8-1-1 0-.6.4 0 .7-.5-.5-1.4.4-3 .2-4.5 0 0-.4.3-.6 0l1-1c-.2-.2-1-.2-.5-.8-.2 0-.4.2-.4 0 1-3-.5-6.3 1-9.5-.3.5-.4.2-.4-.2 0 .3-.4 0-.6 0l.6-1.3c-.6-.2 0-1.4-.6-1.5v.4a.6.6 0 0 0-.2 0v-1l-.3-.2v-3h-1l-.4-2a3.6 3.6 0 0 1-2.4 2h-.7c-1.6 0-1.7-2-1.7-2s-.2 1.7-3.6 2-3.3-2-3.3-2a2 2 0 0 1-1.8 2c-1.2.4-2.2-4.7-2.2-4.7s.2 3.7-2.4 4.4-2.6-2.3-2.6-2.3c-.7 2-1.5 3-2.7 3.2h-1c-2-.7-2.6-3.4-2.6-3.4s.2 1-2.5 2.8a4 4 0 0 1-.8.4l-2.4-.2a3.8 3.8 0 0 1-1.2-1.2 3.7 3.7 0 0 1 0 1.8h-1v.3a6 6 0 0 0-1 1l-.6 1a8.4 8.4 0 0 1-1.5 2c-.4.6-3 4.4-3.4 5.6a32.8 32.8 0 0 0-2.2 3.3l-.6.3-1.4 2.6c-1.2 1.4-1.7 2-1 .3-2 3.8-1.8 3-3.6 6.2v-.4a40.3 40.3 0 0 1-2.4 3.5c-2 2.2-8.3 12-12.8 18 1.3-.8-2.2 3-2 3.4-.4.3-1 1-.4 0-2 3.3-3.5 4.7-4.7 7-.4.4.3-.7 0-.4a8.4 8.4 0 0 1-1 1.4l.6-1c-2 3.2-2 3.8-2 4.2a15.3 15.3 0 0 0-2.3 3.7c-.5.6-1.3 1.5 0-.5-.7 1.2-4.8 7-4.6 7.2a16 16 0 0 0-1.2 2l-3.6 5.2.5-.7c-.4 1.2-1.4 2-2.7 4.2-3.4 4.4-1.3 2-4.7 6.4l.3-.2c0 .7-3 4-4.6 6.7l.7-1c-1 1.6-3.3 3.8-4.4 5.2-.3.3.3-.5.5-1-3 3.7 0 .7-2 3.6-.5.4 0-1-1.2 1-.8 1-3.4 5.8-5.4 8.3.6-.5 1-1 .2.3zm72.2-23c0 .2 0 0 0 0zm40 17a9.7 9.7 0 0 1 0 1.5c-.2-.3 0-.7 0-1.3zm.6-69.4h-.2c0-.2 0 0 0 0zm-1.5 84h-.2zm.2 0h.2zm0-.2h-.7a4 4 0 0 1 0-1 9.8 9.8 0 0 0 .8 1zm-.2-24h.2v1a.7.7 0 0 0-.3-.2 1 1 0 0 0 0-1zm-.3 21.3v.3c.2.5 0 .6-.2.6a8 8 0 0 1 0-1zm0-9.6a1.5 1.5 0 0 1 .3 0l-.4.7zm.4-14a4 4 0 0 0-.2-.5h.3zm0-1.7v1c0-.2-.3-.6 0-.7a1 1 0 0 0 0-.2zm1-9.2zm1-1.2v.4a1.6 1.6 0 0 0-.3-.2s.2 0 .2-.2zm-2 13.3v.7l-.4-.5a1.6 1.6 0 0 1 .4-.3zm-.2 0a1.8 1.8 0 0 0-.5 0v-.3zm1-12.4h-.5a.4.4 0 0 1 0 .3l1-1v-.2l-.6.8zm-1.4-34.3a1 1 0 0 1 .2-.6v.6a.2.2 0 0 0-.3 0zm-.7-43.8l.5-.2a.6.6 0 0 0-.3-.2 6.8 6.8 0 0 0 0-1h.4a43.8 43.8 0 0 1-.6 4.6h-.3zm0 98c1 .5 1 .8 1.2 1.2l-.4.2.3.7a2.4 2.4 0 0 0-1.4-.7zm.3 6.8V292h.3v1a4.8 4.8 0 0 1-.4.5zm-.4 10.8v-.2.2-3.3c1 .3.6.6.8 1 0 .2 0 .5-.2.8s0 0 0 .2l-.2 1a6.8 6.8 0 0 1 0 .8h-.4zM119 186.3a2.6 2.6 0 0 1-1.7 0h1.7zm-10.8 10.3a1 1 0 0 0 0 .2c-.2 0-.3.3 0-.2zM104 203c0 .2 0 .2.3.2l-1.4 2zm-1 66v-.3l.4-.2-.4 1s-.2 0-.2-.2v.2a.4.4 0 0 1-.3 0zm-6.3 11.2v.7a.7.7 0 0 0-.3-.3zm-22-34.2c.4-.4.2 0 0 .6l.3-.6.6-.6-1 1.6v-.4l-.4.8-.5.7-1 1.3z"
                                class="moko-404__g" />
                            <path d="M154.2 261.7a2.7 2.7 0 0 0 0-.7c0 .3-.3.5 0 .7zm148-45.7v.2a.6.6 0 0 0 0-.2z"
                                class="moko-404__g" />
                            <path
                                d="M182.7 261.2a6 6 0 0 0 0 4c-.3.6-.6 1.6-.6-.6 0 1.2-.6 7.4 0 7.6a6.3 6.3 0 0 0 0 2v5.6-.8c.6 1 .2 2 .2 4l43.5-3.6q0-21 2.7-33.5h.3v-.7l.2-1.4c0 .8 1.3.5 2 0 0-.2-.2-.2 0-1.2-.4.2-1 2-1.2 1 0-1.3.4-1 .8-1.5-.5.3-.3-1.3-.7-1.6l1-3.5a29.8 29.8 0 0 1 2-3.7l.4-.7c.7-.4-.2 1.4.4.8a9 9 0 0 1-1 3h-.7c.3 0 .8-.6.8-1 0 .6-1.5 1.6-1 2.4l.7-.7a9 9 0 0 1-.4 3.3c.8-.4 0-.3 1-1-1 .5 1-2.6-.2-2 1-.4 1-1.2 2-1.8-.2 0-.6 0 0-.7a.8.8 0 0 1 0-.2 1.2 1.2 0 0 1-.5.3c-.2-.5.6-2 .7-2.4.4-.4 0 .3.4.2l.2-1c.4.2 1.5-.7 1 .5l.6-1a4.7 4.7 0 0 0 1.6-1.3c.4-.3.7-1.2.6-.7l1.3-1.3c1.5-.7 3-2 5.2-1.7a4.5 4.5 0 0 1 2-.3l.3.3c.8-.2 2.3.4 2.6 0 .6 1 3.3 1 4.3 1.7l.3-.4 2.6 1.3.2-.5c1 .3 1.8 2 2.7 3 0 0-.3-.2-.4-.5.5 2 3 3 3 5a1.6 1.6 0 0 1 .6 1 .3.3 0 0 0 0-.2v.8a2 2 0 0 0 0-.6 13 13 0 0 0 .8 1.2l-.3.4c0 .6.3.4.6 0a3.8 3.8 0 0 0 .5.6c-.5.7.7 1.3 0 2 .6.3 1 2.5 2 2.6-.2 0-.2.2-.3 0a3.5 3.5 0 0 0 .5 1.6l-.5.4 1 1c-.2 1-.3 1.3-1 .6l1.6 3h-.3c0 .6.8 1.4.5 1.8-.5 1.3.7 6.4.3 9.8 1-.7-.4 1.6.5 1.6-.2.2-.3.7-.6 0 .4 1.8-.3 2.7.5 3.8-.4.2-.5-.4-.6-.2 0 0 .3.5 0 .7s0-.4-.2-.6c0 1.7 1 2 1.6 2a1.7 1.7 0 0 0 .3 2c0 .3-.4.8-.5-.3 0 .7-.3 3.8.3 4a3.3 3.3 0 0 0 0 1v1.7l44 .4q0-8.6-.7-16.5h.2a15 15 0 0 0-.2-2q-.7-8.6-2-16.3v-.7l.4 1.4-.5-1.6 9-152.2-8-1.3-8 128.3a6.8 6.8 0 0 0-.8-1l.8 1v1.6l-1-2c.2.8.6 1.6 1 2.4l-.2 1.4-2.2-4.7a3.5 3.5 0 0 1 .7 1c-1.7-3.5.7.8-.3-1.8l1 2-.7-2-1-1.5-1-1.6 1.8 3.4c-.4-.3-1.2-1.4-1.3-1.2-.8-1.5-1.6-3-2.5-4.3a5.7 5.7 0 0 0 0-1.8c-.2 0-.3 0-1.6-1.4 0 .3.5 1 .8 1.8a2.2 2.2 0 0 0-.3-.5 61 61 0 0 0-4.2-5.7c.2-.2-.7-1-1.7-2a.3.3 0 0 0 0 .2 16 16 0 0 0-1.4-1.5l-.5-.8a31.6 31.6 0 0 1 2.8 2 12 12 0 0 1 2.5 2.7c-.3-1.3-.4-.5-1-2.3.2 1-1-.3-2-1.4s-2-2-1.3-1c-.8-1.8-2-2.4-3.4-4.4 0 0 .4.7-1.2-.7a2.8 2.8 0 0 1-.5-.2h-.2a3 3 0 0 1 .8 1c-1-.4-3.7-2.3-4.8-2.7-1-.8.6 0 0-.5l-1.5-.6c0-.5-2.5-2.2.2-1l-2.3-1.3a15.3 15.3 0 0 0-4.5-2.3c-1-.6-3-.7-2-.7l-2-.5-2-.5c-4-1.2-8.2-1.2-12.7-2.3h-5l-.4-.5c-1.7 0-5.2-.3-6 0-2-1-8.5.6-11.5 1.2v.5a35.8 35.8 0 0 0-6.4 2l.3.4c-2 1-5.7 1.7-8.8 3.5a4 4 0 0 1 1.6-1c-4.4 1-7.5 5.2-10.8 7.2a7.8 7.8 0 0 1-1.7 1.6 1.4 1.4 0 0 0 .2-.2l-.3.3a10.5 10.5 0 0 1-1 .7 8.7 8.7 0 0 0 1-.7 19 19 0 0 0-2 2.3h-.8v.2c-1 .7-.5.8 0 .6a7.7 7.7 0 0 0-.6 1.4c-1.2.2-1.7 2.4-3 3-.2.6-2.5 4-2.5 5.3a12.7 12.7 0 0 0-1.7 3l-.7.3-.6 2.7c-1 1.3-1.4 2-1.2.2-1 3.8-1 3-1.6 6.3l-.3-.3c-.4 1-.5 3-1 3.6a35.2 35.2 0 0 0-2.6 8c-1 3.6-1.7 7.8-2.6 11 1.4-1-1 3 0 3.5-.3.4-.6 1.3-.7.2-.2 3.4-1 5-.6 7.5-.3.4-.3-.8-.5-.4a3.7 3.7 0 0 1 0 1.4l-.2-1c-.2 3.4.5 4 1.2 4.2zm119.5-45a.3.3 0 0 1-.2 0c-.4-1 0-.3.2 0zM287.8 198v.2a51.4 51.4 0 0 0-5-3.8 16.8 16.8 0 0 1 5 3.5zM262 234v-.5l-1-1a9 9 0 0 1 2.2.8l1 2a7 7 0 0 1-2.2-1.4zm5.5 14.2a1.5 1.5 0 0 0 .8 0l.2 1zm2.8 24.6l-.4-1.7s.2 0 .5.4v-.3q0-.2.2-.2v1l-.2-.3.2.4v.3a7.3 7.3 0 0 0-.4.7zm4.6-84.5c-1.4-.8-1-.5 0 0zm-12-3c3.2.6 1.3 1 1.8 1a24.5 24.5 0 0 0 5.3 1 9 9 0 0 1 4.5 1.6c1 .6.7.8.4 1a57.8 57.8 0 0 0-16.2-4.7 21.4 21.4 0 0 1 4.2 0zm-6.4 41.5l-.3.7.5-.5 1.2.8a2.3 2.3 0 0 1-1 1c0-.2-1.4-1.8-1.7-2.3a.4.4 0 0 1 0-.2 15.5 15.5 0 0 1 1.4.7zM251 225a5 5 0 0 1-1.2.3s0-.3-.2-.4h1.2zm-14 6.7c.6-.4.4-.2 0 0zm6.8-47h-.5zm-6 44.2l-1 .4a2.8 2.8 0 0 1 1.3-1.2 1.3 1.3 0 0 0-.4.2 15.7 15.7 0 0 1 5.5-2.7 11.5 11.5 0 0 1-2.2 2c-1.2 1-.8 0-1 .2a3 3 0 0 0-1.7 1.8 2.8 2.8 0 0 1-1.3 1.6c-1 .4-.7-.6-1-.7.7-1 1.5-1.2 2.2-1.7zm-9 15.5l.5-1.6a2.6 2.6 0 0 1-.5 1.5zm-2-58a34.3 34.3 0 0 1 5.7-.3l-2.5.6v-.4l-.2.5-3 .8a1.2 1.2 0 0 1 .2-1zm-14.2 6.5h.8l1-1 1.3-1-2 2.8-4 3a13 13 0 0 1 3-3.7zM196 211a.6.6 0 0 0 0 .3c-.2 0-.4.2 0-.2zm-3 6.3c0 .3.4.3.8.4l-.8 2v-2.4zm-9.3 45.3v-.6c0-.5.2-.6.3-.6v1.8l-.2-.4v1.6c0 .6-.3 1-.4 1.4l-.2-3.5c.2-.4.4 0 .6.5zm157.6 17l46.5 1.6c.4 0 .6-.2.8 0h.2c0-1 .2-.7 0-1.7l.4.3c0-.3 0-1 .3-1 1-.3 1.8-3.2 3.3-4.5-1-.2.8-.5 0-1 .4 0 .6 0 .7.3.2-1 1-1 .8-2 .2 0 .2.4.4.3a.6.6 0 0 1 0-.5c.2 0 .2.3.2.5.3-1-.3-1.3-1-1.8.6-.2.7-.5.4-1 .3 0 .7-.2.4.4.2-.3 1.3-1.7.8-2 .2 0 .2-.4.2-.5a9.6 9.6 0 0 0 .8-1.3h-.2c-.5-.5 0-.6.4-1 1-1 0-.8 1.2-1.7h-.4c-.8-.7 1-1 1-1.5h-.3c0-.3.3-.3.7 0l.7.4v.2c.5.3-.3-.7-.2-1.2 0 .3.3 1 .4 1v-.8s0-1 .2-.7a4 4 0 0 1 0-1.4c0-.2.2 0 .3.2s0 0 .3-1a3.4 3.4 0 0 1 0 .4c0-.7.5-1.6.8-3-.3 2.2 0 1.3.3.3s.6-2.4 0 .3l.4-1-.2.6v-.2a11.2 11.2 0 0 0 .6-1.7l-.4 1.3c-.3 1.8-.2 1.4.5 0l-.6 1.5c.2-.3 0 .5-.2 1.2s-.3 1.2 0 1a3.5 3.5 0 0 1-.2.3c.3-.2 0 1-.3 1.5s-.2.7.6 0a1.5 1.5 0 0 1 .4.3c0-1 .7-.3 1-1 0 .6-.6 1.6-.6 1h.2c-1 .4-.3 1.3-1 1.5v1.5l-.3 1.7a22 22 0 0 0-.5 3.6l.7-.2v1c-.3 0-.6.2-.6-.4-.4.3.3 1 .4 1-.3 1-.8-.5-.8-.2v.5c.4.3.7.3.6 1 0 .4-.4.2-.4.4v1.2l.4-.4c.2.5 0 1 .5.5-1 .7-.5 4-.8 4.3a3.3 3.3 0 0 1 .3 2s.7-.2.6.5a.7.7 0 0 0-1 .5c10.4-.2 27.5-.4 39.7-.4v-6c0-.2.2-.3.3-.5s-.2 0-.2 0v-7.6c.5-1 0-.6.7-2.4-.8 1.6-.6-5.8-.6-4.7a20.3 20.3 0 0 1 .7-5.7c-.2 0-.4 1-.4-1.3a3 3 0 0 1-.2-.5v-8.3c0-.7.2-1 .3 1V242a25 25 0 0 0 0-5.5c.2-1.3-.3-3.4 0-2.2l-.3-4.5c0-4.5-.6-9.2 0-14.3a42.2 42.2 0 0 1 0-5.6l.3-.6c0-2 .3-5.8 0-6.6.5-1 .5-3.4.5-6v-7.5h-.6V185h-.3a4.3 4.3 0 0 0-.7-2.6 4 4 0 0 1-1.5 2.6H435l-1.3.2v.3a4.7 4.7 0 0 1-2.6-3c-1.7 5.6-3 1-3 1a12.8 12.8 0 0 1-2 2l-2.4-.2a4.8 4.8 0 0 1 2 0 17 17 0 0 0-3.4-.3 7.5 7.5 0 0 1-.7-2.7 8.4 8.4 0 0 1-6.3 3c-3.3 0-5.6-3.5-5.6-3.5a4.3 4.3 0 0 1-1.8 3.2h-.5.5-.2a18.5 18.5 0 0 0-2.3.2l-.5-.5h-.7a2.8 2.8 0 0 0-1.3-1.5 4.6 4.6 0 0 1 0 2.2h-.6v.3a2.6 2.6 0 0 0-1 1 15 15 0 0 0-1 1.2 4.3 4.3 0 0 1-1.4 1.7c-.2.8-2.8 4.6-3 6a16.5 16.5 0 0 0-2 3.3h-1l-1 3c-1 1.3-1.7 1.8-1 0a7.5 7.5 0 0 1-1 2 8.6 8.6 0 0 0-2-4.2 17 17 0 0 1-.3 8.7l-.2-.3c-.6 1-1.4 3-2 3.6-2.3 2-8.2 12-13 18 1.7-.6-2.3 2.6-1.8 3.3-.4.3-1 1-.6 0-2 3.3-3.6 4.5-4.5 7-.3.3.3-.8 0-.5a4.2 4.2 0 0 1-1 1.4c-.2 0 .2-.7.5-1.3-2.2 3.3-1.7 4-1.3 4.7a7.8 7.8 0 0 0-2.3 3.8c-.7.4-1.5 1.3-.3-.8-.8 1-5 6.8-4.6 7.2a8 8 0 0 0-1.2 2c-1.7 2.4-2 2.6-3.6 5.2l.6-.7c0 1.5-1.3 2.3-2.6 4.4v-.2c-3.5 4.3-1 2.2-4.7 6.2h.5c.5 1-3 4-4.6 6.8l1-.8a5 5 0 0 1-1.4 1.6zm61-7h.2c.2.3 0 .2 0 0zM442 240v-.2c.2-1.6 0-1 0 0zM399 196zm-2 0a.7.7 0 0 0 0 .3s-.4.3 0-.2zm-2.8 72.4l-.2 1s-.2 0-.4-.4v.2a.3.3 0 0 1-.3 0l.3-.4v.2-.3l.2-.2a4.4 4.4 0 0 0 .6-.2zm-1.2-65.8c0 .4.5.4 1 .5a19.3 19.3 0 0 1-1.7 2zm-5.7 77.4l.4 1a2.6 2.6 0 0 0-.7-.4zm-12.5-48.7c-.2.8 0 1 0 1l-2.8 4.2a52.7 52.7 0 0 1 2.7-5.2zM364 245.8c.3-.3.3 0 0 .8l.4-.7c1-1 .8-.3.6.7l-1 1a3.3 3.3 0 0 0-.3 1l-1 1.5c0-.7.5-1.5.8-2.2l-1.5 1.3z"
                                class="moko-404__g" />
                            <path
                                d="M151 296l.2.4h.2v-1.2h-.8c-15.7.3-20.7-5.4-20.7-5.4-1 3.5-9.7 3.5-9.7 3.5 3.7-2.7 2-12.4 2-12.4-.6 8-7.8 12.5-10 13.7a27.8 27.8 0 0 1 0-4c0-.3 0-.2 0 0 .2-.7-.2-.6-.3-1v5l-.6.4.6 1.6a17.8 17.8 0 0 1-.5 4c0-.4.2 0 .2.2 0-.2.2 0 .3 0l-.4 1.4c.3.3 0 1.5.2 1.7v-.5a3.8 3.8 0 0 1 0 .7H93v.3-.3h-1c.5 0 .2-.5-.3-.8 0 0 0 .3-.6.4.3 0 1.4.3 1 .5-.8 0-.7-.3-1-.4l-.8.3h-4.4v.2l-.4.2c-.3-.2.7-.2.3-.3a3.7 3.7 0 0 1 1.8-.2l.2.3H87c.3-.2 1.2.3 1.5 0l-.5-.3a5 5 0 0 1 2-.3c-.3-.4 0 0-.6-.4.5.4-1.7 0-1 .4-.5-.4-1 0-1.5-.5 0 0 0 .2-.4 0v.2a.7.7 0 0 1 .2.2 1 1 0 0 1-.3 0h-.2a3.3 3.3 0 0 0-.5.3s.2 0 .2-.2l-.4.3c0-.2 0-.3.4-.4h-.2v-.2s.2 0 0-.2a2.4 2.4 0 0 1 0-.4h.2l.3-.5.4-.8a5.2 5.2 0 0 1 1-1.6 5.3 5.3 0 0 1 .6-1.2h.3c.2-.4 1-1.2.8-1.5.7-.2 1.3-2 1.7-2.7a12.3 12.3 0 0 0 .7-1.8h-.2A17.2 17.2 0 0 1 93 291a1 1 0 0 1-.2.5 3.3 3.3 0 0 0 1-1.6l.3-.6-1.5 5.3.4-.3a1.6 1.6 0 0 0-.4.3 6.2 6.2 0 0 0 .4-.8h.2v-.2c.2-.2 0-.2-.2-.2a2 2 0 0 0 0-.4c.6 0 .4-.7 1-.8 0-.2.5-1.4.3-1.7 0 0 .2 0 0 0a2 2 0 0 0 .5-.8h.3v-1c.5-.3.6-.4.6 0l.5-1.7.2.2a1.2 1.2 0 0 0 0-.2h-1c2-4.5.6-10.4.6-10.4-1.4 8-11 9.2-11 9.2 2-.8 2-3.3 2-3.3-2.2 2.8-29.3 4.6-29.3 4.6h-7.7c-1 1.4-2.7 3-3.6 4-.3.3.2-.5.5-1-3 3.7 0 .7-2 3.6-.5.4 0-1-1.2 1-.8 1-1-1.2-3 1.3.4-.5 1-1 0 .3-1.4 2-4 5.2-5 7.3l-.4.4-2.6 4a8.7 8.7 0 0 0 0 2l.2 1c-.8 1.7.4 11.6-.4 11.6v5.8-.2 8.4h6c1.2 0 2.4 0 4.5-.2l.5.2c1.2 0 7.8.4 13 0a1.6 1.6 0 0 1-.5.2c6-.2 14.2.7 16.4-.2l4-.2c-5 0 .7-.3-1.4-.5 2 0 5 .3 2.7.3H77c-1 .5 6.2.2 6 .5l15 .2h13.5l-.5-.3h1v1.4a2 2 0 0 1-.2-.5 5 5 0 0 1 0-.7 12.7 12.7 0 0 0 .2 3.3c-.2 4.5-.4-1.8-.4-.4v1.5a27.8 27.8 0 0 1 .2 4.4c0 2-.2 1-.2 1.7a4.3 4.3 0 0 0 0 1v4.2l.2-1.7c0 1.8 0 4 .3 2-.4 2.8 0 15.4-.2 17v5.3h4.4c-.8-.2-1.3-.5 1.4-.4-1 .6 5 .3 7 .7-2-.4 7.7-.2 4.7-.6 2.2 0 0 .2 1.8.4h18.7s-1.5 0 .5-.2h1.4l.2-1.6v-1.5c0-1.3-.3-1.2 0-3.6 0 .2-.2.7-.3 0 .2-5.4.2-10.8 0-16.3v-16l6.5.3c-1.8 0-.6 0 .8-.2-1 0 0-.2-.2-.3l5.5.3c1-.3 6 0 6.6-.3H169c1.3-.2.2-.6-1-.6h5.6v-32h-23zm-63.2.7h-.3l.4-.6a2.3 2.3 0 0 1-.3.7zm1.5-3l.3-.6.3.2-.4-.3.4-1a1 1 0 0 1 .5.5 11.3 11.3 0 0 1-1.2 1zm5.2-6a.6.6 0 0 0-.3 0l.2-.4zM85 303.5c.3-.2.2-.2 0 0zm0-1.3c-.8 1.3.4.8-.4 1.6-.2.4-1 .6-1 .8h-.2a10.6 10.6 0 0 1 1-1.4l-.4.6a1.5 1.5 0 0 1 .4-.8 1.5 1.5 0 0 0-.2.2l1.7-3a4 4 0 0 1-.4 1.7c-.3.8-.4.2-.4.4zm27 45v-.7.7zm.8-49.4a2.7 2.7 0 0 1-.3 1.2v-2zm0 7h-.2v-1l.2-.2v-.2zm-.3-4.2a6.5 6.5 0 0 1 0 1.4v-3c.2-.3 0 2 .4 1.2-.2.5-.3 0-.5.4zm126.7 29.2zm0 0v.4a3.7 3.7 0 0 0 0-.5zm0-.3v-.4.4zm0 0v.4a1 1 0 0 0 0-.3zM239.2 329v-.2zm.3.5a1 1 0 0 1 0 .2 1 1 0 0 0 0-.3zm0 .2zm0 0v-.5.5zm0-.3v-.4.6-.2"
                                class="moko-404__f" />
                            <path
                                d="M314.8 279.3l-.3-1.6c0-.2 0-.6-.2-.7l-1 .2.2-.7h1.4a4 4 0 0 1-1.5-.2 1.8 1.8 0 0 1 .6-.3h-.5c0-2 0-4-.7-4-1 0-1 3-3.4 3s-1.4-3-2.4-3-.2 2.2-4.3 2.8-3-3.4-3.8-3-2.2 2.6-2.2 2.6c-1.4.7-1.7-6.4-2.5-6.3s.3 5.2-2.8 6-2-3.5-3-3.3-2.7 4.8-5 4.6c-3-.3-2.7-4.7-4-5s.2 1.5-3 3.8-3.7-1.8-5-1.4c-.8.2-1.3 2.3-1.7 4l-1-.3-.3 1.5-.2 2v1.4a.7.7 0 0 1 0-.3 5.6 5.6 0 0 0 0 .5 5.5 5.5 0 0 0 .4 1.7v1.9c0-.4 0-.5-.4 0a4.4 4.4 0 0 0-.5.6v.3c0-.2 0-.2 0 0s0 .2.2 0l.5-.6v.3a5.8 5.8 0 0 0-.5 2.3v.5h.4s-.4 0 0 0a6.7 6.7 0 0 0-.5 1.6v.5a1.8 1.8 0 0 0-1 .7c0-.3-.2-.3-.3-.3a.4.4 0 0 1 .3 0s-.5.4-.5.6l.3-.2c0-.3 0-.4-.2-.4s0-.2 0 0v-1.3h-.2a.7.7 0 0 0-.4.3v-.2c.4 0 .2-.2.3-.3v-.2h.3-.3v.3a3.2 3.2 0 0 0-.2.8c0 .3 0 .5.2.6a.7.7 0 0 0 .3 0l.2.2s0 .5.3.5a2 2 0 0 0 0 .4 3.2 3.2 0 0 0 0 .5 4.2 4.2 0 0 0 0 .5c0 .3.5.7 1 1.2v.3a2.6 2.6 0 0 0-.4.3l-.3.3 1.4 1a1 1 0 0 1 0 .3l.2.2v-.2h.2-.4a1.2 1.2 0 0 0 .3 0h.4v.2-.2a3 3 0 0 1 0 .5l-1-.5h.3-.2l-1-.8 1 1-1-1 .6 1h.2a1.6 1.6 0 0 1 0 .6l.7 1a3.5 3.5 0 0 0-.3 2 5.6 5.6 0 0 1-.4-2.8l-.3-.5a3.8 3.8 0 0 0-.6 0 .8.8 0 0 0 .5 0h-.2l.3-.4-1 .4.8-.5h-.6-.5v.3l-.4 1a7 7 0 0 0-.3 1.6 4.3 4.3 0 0 0 .5 2.6v.4l.3 1a4.6 4.6 0 0 0 .7 1.7v-.4a3.6 3.6 0 0 1-.3-1 2.6 2.6 0 0 1 1-1v.5l.2-.6h.2l-.3 1a4 4 0 0 0 .2.3 2 2 0 0 0-.4 1 6.6 6.6 0 0 0 0 1.2c-.3 1-1-1-1.3-1l.2 2a6.7 6.7 0 0 1 0 1h-.4a3 3 0 0 1 .6.2h.3l-1.3.5v.2l1.4-.5-1.7.4v2.4a16.2 16.2 0 0 0-.4 2.2l-.2.3c-.6.7-1.3 1.8-1 2a2 2 0 0 1 1.3-1 2.8 2.8 0 0 1 .7 0l-1.3 1a2.6 2.6 0 0 0 .4.4 2.5 2.5 0 0 0 .8.4 7.4 7.4 0 0 0 0 1.5l-.3-.2v.7h.2v.3h-.5a7.2 7.2 0 0 1-1 2.2c-.6 0 .2-2.8-.8-2l-.3 1.3c-.6 1-.3-.7-1.2 1.5a2.3 2.3 0 0 1-.2 1.3h-.2v.3l-1.7-.3a3.6 3.6 0 0 0 0 1 3.4 3.4 0 0 0 .5 1.3l-.6.6c.4-.2.3.2 0 .7l-.2.7a2.2 2.2 0 0 0-.4 0 3.2 3.2 0 0 0-1 0l-.4.3h-.2l-.6.5 2 2h-.4v.2h.4v-.2h-.2l.3-.2v.4a.8.8 0 0 0 0 .2.2.2 0 0 0 .2.2 2.3 2.3 0 0 1-.7.4h-.5.4a.3.3 0 0 0-.2-.3.3.3 0 0 0 0-.3.6.6 0 0 0-.4 0 4 4 0 0 0-.7.3l-.7.3h-.3a.3.3 0 0 1 0 .2l-.4-.2a14 14 0 0 1-3.5 1c-.4 0-2.3 0-1.5-.3a5.8 5.8 0 0 1-2.3.3c-1.2-.4-.5-.4.2-.3s1.5 0 .6-.4a3.6 3.6 0 0 1-1.8.3 7.6 7.6 0 0 1-1.5-.2l-1-.2h-.3v-.2l-.3-.2a.8.8 0 0 0 0 .3v.2h-.5.2v-.2h-.2l-.4-.3-.4 1a1.4 1.4 0 0 0-.6 0h-.3c-.6-.6 1.3-.3 1-.5h-.6v-.2.2h-.5v-.2h.2l-.2-.2v-.3h1.2l.5.3.6-1.2h-.2l-2.5.4.6-.6-.5.3a1.4 1.4 0 0 1 .4 0h-.3.2c.2-.2 0 0-.2 0a1 1 0 0 0 .5-.3v.2a1.4 1.4 0 0 1-.3 0h.3l-.3.2.3-.3h-.3.3a.3.3 0 0 0-.2 0l.3-.2-.3.2.3-.2h-.6.3l-.4.2v-.2l-.2-1-.4.3v-.2l-.2.4h-.2s.3-.3.3-.5v.4-.3l.3-.4v.4l-.2.4v.2-.2.2l.2-.2v-.2.4l.2-.3-.4.4v.2l-.5.5v-.3l.5-.3v-.4l-.4.3v-.3a2.8 2.8 0 0 0 0-.5.3.3 0 0 0-.2-.3 1 1 0 0 0 0 .3.8.8 0 0 1 0-.2v1-1V328.5v-.6c0 .7-.2 0 0 .7a9 9 0 0 0-.3-1v1a1.8 1.8 0 0 1 .2.6.8.8 0 0 0 0-.4v.3a4 4 0 0 1-.3-.8c-.2-.2-.3-.3-.3 0 0-.2.2.4 0 0v.4c-.2 0-.2 0-.3.2v.2a5 5 0 0 1-.3.4h-.2c.2-.3.6-.2.4-.5a1 1 0 0 0-.5.2 20.8 20.8 0 0 0-1.2-1.8 13.8 13.8 0 0 1-2-3.5v-.4a4 4 0 0 1-.4-.5 3 3 0 0 0 .5-.7 3 3 0 0 0 .4-1.8 3 3 0 0 1-1 2.3h-.2a2.5 2.5 0 0 0 .5-.7 2.7 2.7 0 0 0 .4-.8 2.7 2.7 0 0 1-.2.7v-.4l-.2.6a2.6 2.6 0 0 1-.5.5l-.2-.4a2 2 0 0 0 .8-1.7h.6a3 3 0 0 1 0 .2v-.3h-.7.6-.5l-.6.2-1 .3 1-.2h-1l-.6.2a1.5 1.5 0 0 1-.3-.6c1.4 0 0-2.4.5-3.5-.2.4-.5-.4-.7-1.4 0 1 .3 1 .3 1l-.2-1 1 .2h-1 1-.2.3l-1-.4h-.2v-.2a1.2 1.2 0 0 0-.4-.4.3.3 0 0 1 0 .2 1.5 1.5 0 0 1 .2.3c-.2-1-.4-.6-.6 0a2 2 0 0 1 0-.4.5.5 0 0 1 .2-.3.5.5 0 0 0-.2 0c0-.6.5 0 .6-.7a19.4 19.4 0 0 1-1-5.8h.2l-.3-1.3a.4.4 0 0 0 0-.2 3.4 3.4 0 0 1 0-.3.4.4 0 0 0-.2-.3h-.2l.4-.2v.2h.3v-.2h-.3a.6.6 0 0 0-.4 0s0 .4-.3 0l.6-1.5c0-.6-1-.4-.5-1.5a.3.3 0 0 0-.3.2.6.6 0 0 1 0-.2 26.2 26.2 0 0 0-.2-2.8v-.4a4 4 0 0 1 0-.6 66.3 66.3 0 0 1-.6-11h.3a3.4 3.4 0 0 0 2-1 3.3 3.3 0 0 0 .4-1c.2-.4.2 0 .2-1 0 1 0 .6-.2 1a3 3 0 0 1-1.7 1.6 3 3 0 0 1-1 .4h-.5a19.6 19.6 0 0 1 .4-2.8c-.3.6-.3.4-.4 0l2.8.2-2.8-.2v-.3c0 .5-.4 0-.7.2l.5-2.5c-.4-.2-.4-1-.4-1.8l1.8-.7-.2-.7h-.3v.8s0-.4.2 0l-1.8.6a2 2 0 0 0 0-.7h.4a4.8 4.8 0 0 0 0 .6l.3-.2v-.7h.8l-.7.2h-.2l-.5.3.6-.2-.7.2-.2.2h.2v.6c0-.2-.3-.2-.5-.2l.2-.2-.3.3a1 1 0 0 0-.3.3h-.5l-.3.6s0-.2 0 0v-3h.3c.5-2-.4-6.3-.4-6.3s-1 3-3.4 3-2.5-3-2.5-3-.2 2.3-4.3 3-3.8-3.2-3.8-3.2c-.3 2.6-2 2.7-2 2.7-1.5.7-2.7-6.3-2.7-6.3s.2 5-3 6-3-3.6-3-3.6c-1 3.8-2.6 4.8-5 4.6-3-.3-3.8-4.8-3.8-4.8s.2 1.4-3 3.7-5-1.5-5-1.5a7 7 0 0 1-.7 3.8l-.2-.2v.5h-1v1l-2.2-.2 2.4.2h.4a3 3 0 0 1 0 .7 1.4 1.4 0 0 1-.2.5h.3a23.6 23.6 0 0 0-.2 2.7v.4l-.2.2-.8.3.3.3-.6.3.7-.4h.2a3.3 3.3 0 0 1-.5.8l-.4-.5h-.2.2l.4.5a.3.3 0 0 1-.2 0 6.2 6.2 0 0 1 .2 1 3.5 3.5 0 0 1 0 1c0 .7-.3 2-.5 3.3h.2s0-.2 0 0h.5v1.2a9.3 9.3 0 0 0 0 3c0 1-.2-.7-.4-.2a9.4 9.4 0 0 1 .3 1.3v.7l.2 1a16.3 16.3 0 0 0-.4 1.8l-.3 1.2h.3v.2h-.6a9.2 9.2 0 0 0-.4 1.3.2.2 0 0 1 .2-.3v-.5a.8.8 0 0 1 0-.4l-.3.2a7 7 0 0 0 0 2.6c.2.2.3 0 .4.2a2.3 2.3 0 0 0-.3.8 3.8 3.8 0 0 0 0 1 4.7 4.7 0 0 0 0 1 3.6 3.6 0 0 0 .2 1.2l.2 1 .4 1.5.4-.6a9.6 9.6 0 0 1 .3 2.4c.4.8.3-.2 0-1.3s-.5-2 0-1.3a6.4 6.4 0 0 0 0 1.7l.3 1v.7l.2 1a6.3 6.3 0 0 1 1 .6.8.8 0 0 1 .2.2l-.4.3v.5l.3-.3.3-.3-.7.4a14.2 14.2 0 0 1 0 4.8c.4 2.8 0-1 .8 2a6 6 0 0 0 0 .8 7.4 7.4 0 0 0 .7.5h-.2c.3 1.2.2 2 0 2a8.4 8.4 0 0 0-.6-1.3 16 16 0 0 0 1 3 11 11 0 0 0 .6 1.7 4 4 0 0 0 .5.8 1.5 1.5 0 0 0 0 .7 10.7 10.7 0 0 0 .5 1.6 17 17 0 0 0 1 2.8l1 2.5.2.4-1-.4 1.3 2.5.5 1 1.7 3.6a17.5 17.5 0 0 0 1.7 2.8v-.6a16.3 16.3 0 0 0 1.8 2.3v-.2c-.4-.3 0 0 0 .3l.6 1.5a15.4 15.4 0 0 0 2.2 3.4v-.2l2.5 2.3a1.4 1.4 0 0 1-.2.4l.5.4-.6-.5a1.6 1.6 0 0 1 0-.4v.3l.7.6.3.2v-.2l.3.4-.4-.3.5.5-.4.4-.2.2h.2l.2.3.4.4.6.6a5 5 0 0 0 .8.7 24 24 0 0 1 2 1.4l.3.8a25.7 25.7 0 0 1 3 2.5c-2-1.2 1 1.6-1.2.3a10.6 10.6 0 0 0 1.4 1.2v.2c3 2.3 5 3 6.3 4.8 2.6.8-3.6-3.3-2.3-2.6-.8-1 2 .6 3.4 1.7a21 21 0 0 1 2 1.8 7.8 7.8 0 0 0 1.5 1.2 5.8 5.8 0 0 0 1.2.5 4.6 4.6 0 0 0 1.2.2 23.4 23.4 0 0 0 3.3.8v-.4l.2.2a6 6 0 0 0 1.7 1 12.4 12.4 0 0 0 2 .6h.4l-1.2.7 2.8.2v.4c2.5 0 4.6 1.3 7 1.4-5-.8-1-.7-3-1.4 3 .2 4 .6 4.8 1a11 11 0 0 0 5 1.2c-1 0-3-.5-1.6-.6a36.8 36.8 0 0 1 3.8.7c4.6 0-.7-.5 1.3-.7 1.6.6 2.3-.2 4.3-.4v.5c4.3 0 2.5-.7 4.2-1l-.3.4h1-.3l-.7.4h.6l.3-.2a4.8 4.8 0 0 0 1.5 0c-.2 0-.2-.2 0-.3l1.6-.4a1.6 1.6 0 0 0-.2.4.6.6 0 0 0 .5 0v-.3l.2-.2.2.3a3.4 3.4 0 0 1 .6 0l1.5-.5.6-.2a5.8 5.8 0 0 0 .7-.5c.6 0 .3.2-.2.6.5-.2.7 0 1-.3a1.8 1.8 0 0 1 1-.2c0 .2-.3.4-1 .8a6.3 6.3 0 0 1 1-.5 2.5 2.5 0 0 1 .8-.2 2.5 2.5 0 0 0 1 0H269v.2-.2l.2.7-.3-.8v.7l-.2-.7v.5a.5.5 0 0 0 0-.3 5.7 5.7 0 0 0 .5 0h1.4l.3.2a3 3 0 0 0-.2-.4c.4 0 .6 0 .4.2a12 12 0 0 0 2.6-1l-.2-1 1-.5c.3-.3-.3 0 0-.2h.6a8.4 8.4 0 0 1 1.2-.5 44.2 44.2 0 0 0 4.4-1.8 18.5 18.5 0 0 0 4.3-3l2.2-.5a2.2 2.2 0 0 0 .3-.3c.6-.7.3-.6-.2-.4-.3 0-1 .2-.3-.5l.8-.6.6-.6c2.2-2.4 1.3-.4 2.3-1a26 26 0 0 1 2-2.8h.6l-.3.6.3.3a1 1 0 0 1 .2-.8l.3.2c-.2.3-.2.3.2 0l-.2-.4a5.2 5.2 0 0 1 .4-.6 4.8 4.8 0 0 0 .7-.4 9.3 9.3 0 0 0 .8-.8l1.4-1.4a22.2 22.2 0 0 0 1.6-2l-.7-.8-1-1.5 1.6-2v.4l.2.2v.3l.4-.3-.2.2c.4-.3.4-.4.4-.7a2 2 0 0 0 .6 0 4 4 0 0 0 .6 0 3.8 3.8 0 0 0 1-.7l.3-.3a9 9 0 0 0-1.3.6 3.2 3.2 0 0 1-.6.2 3 3 0 0 1-.6 0v-.7a2 2 0 0 0 .6 0 2.3 2.3 0 0 0 .4 0 3.5 3.5 0 0 0 1-1l.3-.3.2-.3c.5-1 1-2 1-1l1-2.8c.3-.6.5-.5.3 0l1-1.7 1-2c0-.8.4-2.3.5-3 .7-1 0 .6.2.4l.3-1.2.3-1.3c.4-.6.4 0 .3.5a11 11 0 0 1-1 2.5 3.2 3.2 0 0 0 1.3-2v-.8l.4-1.2.3-1c.3-.3.3 0 .4-.2l.6-1 .6-.7a9 9 0 0 0 .6-1 5.3 5.3 0 0 0 .3-1.4 5.6 5.6 0 0 0 0-.7 5.3 5.3 0 0 1-.2 1.3 5.4 5.4 0 0 1-1.5 2.3l-.2.3h-.6a3 3 0 0 1 .2-.5 5.8 5.8 0 0 0 1-1.8 3.7 3.7 0 0 0 0-1.3 4.3 4.3 0 0 0 0-.5s.2 0 .4-.5l-.6-.4h.2l1 .7a3 3 0 0 0-.3.4 2.2 2.2 0 0 0 .3-.3l-1-.6.8.2-.7-.2.4-1.4.6.2a11 11 0 0 0 0-3c.7-2.3 1.2-2.6 1.7-3 .8-3.6-1.3 2.2-.5-2a31.2 31.2 0 0 0 1-8.5c.4-2 .3.4.6-.3l-.2-2c0-.4.2-.2.2 0 0-1.7-.6-.3-.5-2.7-.6-.7 1.5-4.8 1.2-7.8.3-.8.3.3.6 0v-4l-.6-.3v-.2a2.4 2.4 0 0 0 .3-.7h-.5l.3-1.3c-.3 1-.5 1-.7.2a13 13 0 0 1-.2-1.4 13.5 13.5 0 0 1 0-1.8l-.2.3v-.8.5l.3-.4v-.2a1 1 0 0 1-.4-.3 4.8 4.8 0 0 1 0-.8v-1l.5 1a4 4 0 0 0 0 1v.2c0 1 .4 2 .7 1.8a7 7 0 0 1 0-1.3c0 .2 0 .4.2.3a2 2 0 0 0 0-.8l-.8-.5a2.8 2.8 0 0 1 .4-.3l.7-.6h-.3l.5-5a26.7 26.7 0 0 0-.5-3.3zm-6.2 56zm-83.6 39v.2c.2 0 .3 0 .3.3h-.2v-.3l-.2-.2v-.2zm1 .4h.2-.2l-.2.3v-.2h-.2.2zm0 .4l.2-.3-.2.3zm13.6-43.6v-.4l-.2.4v-.2zm28.3-42.6v-.2a.2.2 0 0 1 0 .2v.2zm.8-8.3a.7.7 0 0 1 0 .2l-.4.2a1.5 1.5 0 0 1 .3-.4zM260 377a1 1 0 0 1 0 .2zM239 332l.2-.5-.3.6zm0-.4v.2-.2l-.2.6zm-1-.3v.3zm59.6 20.8h.2a.8.8 0 0 0-.2.2zm-29.8-59.5a1 1 0 0 1 .2.4l-.7.2a.8.8 0 0 1 0-.3 2.3 2.3 0 0 1 .5-.3zm-.5.6l.7-.3a.5.5 0 0 0-.5.3.8.8 0 0 0-.2.4 1 1 0 0 1 0-.5zm-28 39v-.7l.2.6zm-.7-.5v-.2zm-8.5-14zm-5.3 57.3zm35.6 2.6a1 1 0 0 0 0-.3h1.3c-.6.3-1.4.6-.8.5l1-.3v.4h-.5zm2 0v-.3.3zm29.7-15zm4.3-7.2v.2zM268 282l1-.7v.6a2.7 2.7 0 0 1-.8 0zm-.3 7.5v-.7a2.2 2.2 0 0 1 .2-.6 3.4 3.4 0 0 0 0 .6V289.4zm-1.3 3.3a.6.6 0 0 1 0 .4zm1 5a.6.6 0 0 1 0 .2zm0 .3h.2zm.3 0l.7.5zm-.6 4l.8-.2-.8.2.2-.6-.5 1a6.4 6.4 0 0 1 .3 1.2 2.6 2.6 0 0 0-1 1v-.8a3 3 0 0 0-.2-.8l.2-.2a3.5 3.5 0 0 1-.2-.4h.6-.5a4 4 0 0 1-.4-1.4 8 8 0 0 1 .2-1.4c.2 0 .3.2.3.7a6 6 0 0 0 .6 2l.5-.7a2.4 2.4 0 0 1 .4.2h.2v.2a1.3 1.3 0 0 1 .3.2zm0 7.6zm-5.7 15h-.2zm-17.7 9h.5c0-.2.2 0 0-.2a7 7 0 0 0 2.3.5 13.7 13.7 0 0 0 3.3-.2c0 .2-.3.5-1 .8a22.4 22.4 0 0 1-4.7-.7v.6-.3.3l-1.2-.3c-.3-.2-.3-.6.6-.3a1 1 0 0 0-.6-.2h.4a2 2 0 0 1 .7 0zm-2-.7zm-.6-1.7zm-.5-1v.2zm-.2.2v-.2zm0 0zm-.3.7l-.5.6.5-.5zm-.7 0zm0 0v.4-.3s.3.6 0 0zm0-.4h-.2zm-.3.2c-.2-.3-.3-.6 0-.3v.5zm-.3-.8zm-1.4 1.2zm-5-7.5v-.2l-.2-.6a.3.3 0 0 0 .2-.2l1-.2a1.5 1.5 0 0 1-.7 1zm.6-1.2l-1 .2zm-1.3 0a.2.2 0 0 1-.3.2zm-1-5.3h-.2.2-.2zm-49-37.5v-.5a2 2 0 0 1 .4.6zm-.4 24.7l-.4.2zm1.8 10.5h.2zm0 .2zm1.3 8.7l-.2-.8h.2a5.8 5.8 0 0 1 1 0l.5.3zm1.2 6l-.3-1 .4.8s0 .2.2.3 0 .2 0 .3c0-.2 0-.3-.2-.5zm14.5 27.4zm21.3 17.6h.3l.5.2-.6-.2zm4 .5l-.4-.2a2.3 2.3 0 0 1 .4 0h.3v.2h.5v.2h-.3a.7.7 0 0 1-.3 0h-.2zm.2.2h.4l.7.3a1.6 1.6 0 0 1-1-.3zm.8-1c0-.2-.2-.2-.3-.3l-.2-.2h-.2v.2l.2.2s.2 0 .3.3h.2v.2s-.2 0 0 0a1.4 1.4 0 0 1-.6-.3s-.2-.3 0-.3h-.2v-.3a5.5 5.5 0 0 1 1 .3 2.5 2.5 0 0 0 .3.3s-.2.2-.2 0zm4.6 4v-.4a10 10 0 0 1 1.6.2zm35-.8l.2-.2zm26-15zm.5 0l.2-.2h.2zm.4 0l.3-.2-.2.3zm1-.8h-.3v.2h-.2a2.8 2.8 0 0 1-.6.4l-.2-.2a4 4 0 0 0 .8-.3h.2-.7.3l.7-.2v.2l.5-.3zm-.4-.3h-.4l-.3.3h-.6l.2-.3.4-.2H293.6l.8-.5a5 5 0 0 1-.7.6zm14.2-26a1 1 0 0 1 0-.5zm.2-.5l.3.3v.2l-.2-.4.3.7zm.4.8v-.2.3zm.8-1v.2h-.2s.2 0-.2 0zm-.6 0h-.3l.6-.6zM315 294v.2a2 2 0 0 1-.3.2v-.4zm-1-.7l.3.4h-.7l.2-.4zm.4-6.7a11 11 0 0 1 .2-2.2 5.2 5.2 0 0 1-.2 2.2z"
                                class="moko-404__f" />
                            <path
                                d="M267 305.8v.2l.5-1.5a.5.5 0 0 0 0-.3zm-6 74h-.4.3zm8.4-2.3l-.3.2zm-3.8-68.7a1 1 0 0 1 0 .2v-.2zm27.8 53.3h.2zm131 287.2h-.2zM292 362.2zm-24-64.6zm-43 76.4zm82.2-154.5a1 1 0 0 1 .3 0h-.2zM266.7 297c0-.2 0-.5-.3-.8 0 .4 0 .5-.2.5h.4l.2.2zm.7-5.8zm25.4 70.6h.2zM225.8 374.6c0-.2-.2-.2-.3-.3v-.2a1.3 1.3 0 0 0 .3.6zm77.8-27.4v.4a3.7 3.7 0 0 0 0-.4zm-35-49.5zm29.7 57v-.2h-.2a.2.2 0 0 1 .3.2zm-72.8 20.6h.2v-.2c-.2 0 0 .2 0 .2h-.3v-.2l-.2.3h.2zm81.7-145.6v.2l.5-.8h-.2zm-39.5 71.7h.2zm-1 .5h.2v-.2zm25.4 61l.5.4-.4-.5m-111.5-61.7h-.2a1 1 0 0 1 0 .2h.2a.3.3 0 0 1 0-.2zm-48 117.2l-.4.7.3-.3zm128.5-39h-.2.2zm7-78zm0-12.3a1.7 1.7 0 0 0 0-.3v.2zm-41.5 85.3zM88.7-90.7zm33.6-22.2l.2.3zm47.4-10.5a.5.5 0 0 1-.3.3c0 .2.2.3.3-.3zm-40 84.6h-.3v.2zm-12.4-54a5 5 0 0 1 .8-1l-.8 1zM121-123a.3.3 0 0 1 .2 0v-.5h-.2v.4zM165.7-84v.2m-21.3 37c.6-.5 1.2-1.3 1.8-2-1.3 1.5-2.6 1.7-2 2zM229-110h-.2m4.8 0l.2.2-.2-.2v-.2m0 0zm-1.4-1.6zm0 0l-.2-.2zm-.2-.2zm4.9-9l.2.2h-.3zm-1.7-.7v.2zm3.7-3.8h-.3a.4.4 0 0 0 .2 0zm-4.4 13.3zm147.7 414v.2zm14.6 45.6h-.3l-.2.2zm-.4.2l.6-.2h-.2zm.2 0h-.2l-.3.2.5-.2m0 0l-.7.3.6-.2zm.2-1.4zm-1 0h.2c0 .2.6 0 0 .2zM340 277c.8-.8.3-.8.3-1-1 1 0 1-.2.8zm45.7 11v-.2zm.3-1.2a4.4 4.4 0 0 0 0 .5 1.2 1.2 0 0 1 0-.5zm-.3 3.7a.7.7 0 0 0 .3-.2h-.2a.3.3 0 0 1 0 .2zm.7-.7s0 .2 0 0zm0 0c-.2 0-.3.2-.4.5a1.5 1.5 0 0 0 .3-.5zm57.4 79.5v1a11 11 0 0 0 0-1zm0-8l-.2-.3c.2.4.3.5.3.2zm21.8-31.3l.3-2zM402 284.4zm-19 16.4h.2s.2 0 0 0h-.2zm3.4 37.2h0zm57.4-40.8a8.2 8.2 0 0 1-.3-3.8l-1.2 1.3zm1 42.8h-.2zm-43.2-39zm-36 35.8a.6.6 0 0 0 0 .2h.3-.5zm.5 0h.4zm.7 0v.2h.2a5 5 0 0 0-.5-.2h.2zM445 340zm7-1h.6l.6-1.6-.6 1.5c-.2.2-1 .2-.5.4zm-86.3-2.7l.3.2h-.2.5-.3l-.4-.2h-.2a.5.5 0 0 0 .2.2h-.5.2zm73.8 39.7zM367 336.8zM786 629.6v.2l.3-.3zm9-13l-.2-.3-.2.2h.5zm28 56.3c1 0 1.2-.2 1-.4l-.8-.4-.2-.2-.4.2a3.7 3.7 0 0 0 .5.5zm-458-335.4v.2l-.2.2a3 3 0 0 1-.5.2h.7a8 8 0 0 0 .4-.7l-.2.2v.2z"
                                class="moko-404__f" />
                            <path
                                d="M464.2 305.3c.5 1.3.8 0 1.3-.5-.6 3 .3 5.7.2 9 0-1.7.3-1.3.4-1l-.2-2.8-.2-2v-1.2c.4 0 .3-2 .5-4.4 0 .5-.2.5-.3.4a18.7 18.7 0 0 1-4.2.4h-2.3a9 9 0 0 0-1.8.3c0-.3.3-.6 3.4-.5-3.4-.7-4.2 1-7.4.5a3.2 3.2 0 0 0 1.4 0c-1.6.2-5.6 0-4.7-.3h-8c-.2 0 0 0 0-.2l.2-.8v-.2-.3h-.2c.8-.3.3 0 0 .2l.3-.2.6-.2h.3v-.2a5.2 5.2 0 0 0-.6-2.3 3.5 3.5 0 0 1 1.3 1l-1.7-5.6v-2.6l.7 2.3.4-2a4 4 0 0 1 .5 1.8 22.7 22.7 0 0 0 0-4.2l.4-2.2h.3v-.7l.4-2.6c.2-.5.3-.8 0-.7l-.3.5v.4h-.4l.3-.4v-.3-1a.7.7 0 0 0-.2 0 .7.7 0 0 1 0-.4v-.4a10 10 0 0 1 0-1.5v.2h-1c.2-.3.4-1 .5-2.7l-.4-.6a40.3 40.3 0 0 0-4.6 1.3h-6l1-.3 3.3-1a15.2 15.2 0 0 1 1.7-.3l2-.3a8 8 0 0 1-2-.4 4 4 0 0 0-.8-.2h-1.4c-.5 0 0 0 .5-.2h2.4-7c.2.5-5 .6-5 1l7.3-.5c.3.7-4 2-8.8 1.8-1.2-.2 1-1 .8-1.3a22 22 0 0 1-4.8.3l2-.4c-2.6-.2-4.2 1-7.3.3-1.2 0-3.3-.8-3.5-.4a2.5 2.5 0 0 1 1.6 2.2h-4l.3-.2h-.7v.2H407c-.5-.5 2.8-1.2 1.5-1.6l-1.4.4c-1 0 .6-.5-2-.4 0 .3-1.5.3-2.2.3h-.6.6l1.2.2h-2.2v1.2a2 2 0 0 1 .6.3l-.8.5a1.6 1.6 0 0 1 0 .8h-.3a2.8 2.8 0 0 0-.5.2 3.5 3.5 0 0 0-.7.4l2.3 3.2c0 .2 0 .3.2.3v.2s-.3 0-.5.2a2.5 2.5 0 0 1 0 .2 1.7 1.7 0 0 1 0 .3 7 7 0 0 1 0 1.4 3.3 3.3 0 0 0-.8 0l.2 1.2v.5a4.5 4.5 0 0 0 0 1h.6l-.8.8h-.2v.2c.3.5.6.4.7.8a.4.4 0 0 1 0 .2h-.2.4v.3h-.3v-.3a13 13 0 0 0-.4 4.2c0 .4-.3 2.5-.6 1.6a6 6 0 0 1 0 2h-.2c0-.8 0-1.4-.3-.6v.6a2.3 2.3 0 0 0-.6.5 3 3 0 0 0-.4.6l.3.2a2.4 2.4 0 0 0-.3.5h.8l.5.4h-.2v-.3h.2a1 1 0 0 1 .4-.2l-.2.4h-.4l.2.2h.5-.6a.8.8 0 0 1 0 .2h.6l-.2.5v.8a6.7 6.7 0 0 0 .3-.7l.4-.5.4.2v-.2h-.3v-.2l.3.3.2.3a.3.3 0 0 1-.3 0v1c.2.2.2.6.2 1l-1.2.4a1 1 0 0 0 0-.2v-.5c.3-.2 0-.3 0-.4l-.5.4v.4l.2.4-.6.2v.4l.8-.3H399c-2.8 0-9.2.3-14 0a2.5 2.5 0 0 0-.7-2.2c-.5-.5-.2-.5-1.2-.6h.3-.2v-.2c0 .3-.2.6-.4 1v.2-.3h-.2c0-.8-.2 0-.2-.3v-.4a7.7 7.7 0 0 1-.2 1h.2-.2v-1a6.6 6.6 0 0 1 0 1v-.3h-.2v-.3.4l-.4.2c0-.2-.3-.3-.3-.4v.7l-.4-.2 1.8-3.2h-.3l-1.6 3h-.2v-.5.4l-.3-.2s0 0-.2 0a2.7 2.7 0 0 0-1.5-.4 1.3 1.3 0 0 0-.3 0 .6.6 0 0 1 0-.3c.2 0 .2 0 0 0a1 1 0 0 1 .5-.3h.2v-.2a2 2 0 0 1 .3-.8v-.2h.6l2.6-.3.4-.6-3 1 .8-1s.2-.3 0-.5c.8 0 1-.5 1.4-1.2.3.4 0 0 .2 0v-.7l.3.4-.2-.4a2.3 2.3 0 0 1 .4-.5l-.4-.3a.3.3 0 0 0 0-.2l.4.2-.2-.3.3.4s-.4-.3-.4-.6c0 .3.6.6.7 1v-.3l-.5-.6v-.2h.2s.2 0 0 0v-.2h.2a.6.6 0 0 0-.2 0v-.2c.3.2 0 0 0 0l.4.2-.3-.3.5.3c.2 0-.6-.4-.3-.3v-.7l.5-.7-.7.6.7-.8v.2l.3-.4a.6.6 0 0 1 .3-.2c0-.2-.7.2-1.2.6l1.2-1.4v.2s0 .2 0 0v.2c0-.3.2.2.3.3l.8-.6.3-.2h.2s-.2 0 0 0a.5.5 0 0 1-.2.2 1.2 1.2 0 0 0 .7-.8h.4a.3.3 0 0 0 .2.3h-.2l-.2.2h.3v-.3a.2.2 0 0 0-.3-.2 2.3 2.3 0 0 0 0-.3l.2-.2-.5-.2-.2-.2 1-.2a3.5 3.5 0 0 1 .5 1.6h.4v-.7a3.8 3.8 0 0 1 .2.5 4 4 0 0 0 0-.4v.3h-.2v-.5a3.8 3.8 0 0 0-.6-1l-1 .2.2-.2h-.6H385.3a3.5 3.5 0 0 1 .8 0h-.7l.4-.2h-.8l.3-.2h-.2a1 1 0 0 1 .2 0 .7.7 0 0 1 0-.3h.2l.5.4-.5-.4a.7.7 0 0 1 .3-.2l.5-.2a1.2 1.2 0 0 0-.3 0 3.2 3.2 0 0 0 .3-.7h.5c.3-.2 0-.3-.5-.3a1.5 1.5 0 0 0 0-.5l.2.3v-.3.3-.3c.6 0 0-1 1-.8-.3-.4 0-1.2 0-1.8a.8.8 0 0 0-.3-.4s.2 0 0 .2h.2l.6.3-.6-.4.6.3.2.3.5.3-.6-.5a1 1 0 0 0-.3-1.2h.3v-.2h-.2.2l.2-.2.2.2a1.8 1.8 0 0 1 .4 1.2 1.7 1.7 0 0 1 0 .3 1.8 1.8 0 0 1-.2.3h.2a2.5 2.5 0 0 0 .2-.3v-.4a2 2 0 0 0-.4-1.3h-.2.3l.3-.2h-.4l.2-.2s0 .2.2.2 0 0 0-.2l2-.3-2 .3a1 1 0 0 0-.3-.5l.4-.2h-.4c1-.4-.8.4.4 0l.3-.2a2.8 2.8 0 0 0-.5.2l.3-.2h-.3.3c-.2 0 .7-.4.2-.2h.2c-.6 0 1-.7-.5 0l.6-.3-.2-.8.4-.2c.3-.2-.4 0-.4.2l.5-.3h-.3a4 4 0 0 1-.5 0h.3l-.3.2h-.2a2.8 2.8 0 0 0 .6-.3h-.8.2c-.3 0-.2 0 0 0a.5.5 0 0 0 0-.2h-.2v-.2h.3-.4.2l.3-.4a2.6 2.6 0 0 1 .7.5 3.4 3.4 0 0 1 1 1.5 3.4 3.4 0 0 0-.4-1 3 3 0 0 0-1-1l-.2-.2.2-.2-.2.2h-.3a2.7 2.7 0 0 0 .7-.8l-48 .2a10 10 0 0 0-.6 1l.8-1c-.6 1.5-2.8 3-4.2 4l-.5.3.3-.5-.6.7h-.2s-.2 0 0 0v-.7-.4h-.2a17.3 17.3 0 0 0-1.3 2v.3a.5.5 0 0 0 0 .2 1.5 1.5 0 0 0-.4 0l-.2.2h-.2l-.2.3a6.4 6.4 0 0 0-.8.8 6 6 0 0 0-1 1.3l-.6 1.2a13.3 13.3 0 0 0-.8 2.4c-.6.8 0-1-.3-.5a5.8 5.8 0 0 1-.6 1.6 8.4 8.4 0 0 1-.4.8l-.3.5-.6.6a5 5 0 0 1 .3 1.2h-.5a2.5 2.5 0 0 1 0 .2h.6v.2h.4v.4h-.2l-1-.2-.4.4-1.7 2c-1.2 1.4-2.4 2.4-3.3 4.8l-.3-.2-1.8 2.6-1.2 2a1.6 1.6 0 0 0-.2.2v2.5l.4-.7v1.3a5.5 5.5 0 0 0-.4 1c0 .7.2.7.3.4a9.3 9.3 0 0 1 .4-1 6.7 6.7 0 0 0-.3 1.3 13.4 13.4 0 0 0 0 2c0 1 0 2.4.2 3.6a21 21 0 0 1 0 3 1.5 1.5 0 0 1-.2.7 4.5 4.5 0 0 0 .6.2 2.4 2.4 0 0 1 .4.2.8.8 0 0 1 .3.2h.2l-1.8.3-.6-.7v6.3l.3 3.6.3 2.4v-1.4a10.3 10.3 0 0 1 0-1.4 15.5 15.5 0 0 0 .2 2.6v5.5h2c1.7 0 3.5.3 5.5.2a36.5 36.5 0 0 0 6-1h-.8l1-.4v1h4.8l-.5-.2c4.5 0 4.6.3 7.8 0v.3h1.4-.2a15.6 15.6 0 0 1 4.3-.2c-1.4.2 3 .7 1 .8 6 0 3 0 7-.8l1 .3a7.6 7.6 0 0 0 2-1l2-.3.4-.2a1.3 1.3 0 0 0-.3.3c-.5.2-.2.2.3.3h.5l.3-.2s.3 0 .2 0h.2v-.2h.2v-.5.2h.3l.2.2a5.5 5.5 0 0 0 .8.2c.8 0 1.5.3 2.5.5l1.3.5.5.2-.2.2h1.4a23.8 23.8 0 0 0 3.3.3h-1c1.8.2 3.7-.3 6 0 1.3-.4 3 .2 3.3-.5h-4.6c2.6 0 5-1 9.4-.4a16.2 16.2 0 0 1-2.5.4c1.2.2 2.4 0 3.7 0-.4 1-5.6 0-8.4.7 1.4.4 5.3-.4 4 .3 2-1 4.8.2 8.2-.5l-.2.4a18.5 18.5 0 0 1 2.6-.2l-1.8.5a11.4 11.4 0 0 1 2.7 0 15.4 15.4 0 0 1-.2 1.8 6.4 6.4 0 0 0 .6 1.7l.2-.3s0-1.5.3-.4a4 4 0 0 0 0 1.8l.3 1a2.4 2.4 0 0 0-.2.3 2.3 2.3 0 0 0-.2.4 2.8 2.8 0 0 0 0 .3v.3a2.5 2.5 0 0 0-.2.3l-.4.2h.6s-.6 0 0 0h-.6.3l-.8.2h1.3l-.3.3c-.3 0 .3-.3.3-.3h-.5l.4.2v-.2c-.3 0 0-.2 0-.2H397a7 7 0 0 1 1 0 2.3 2.3 0 0 0-.7 0h.5v.9h-.2.4v.2h.2-.2v.2l.2-.2h-.4.3-.2.3v.7a1.6 1.6 0 0 0 .2.8 1.5 1.5 0 0 1 .3.8h-.4a7 7 0 0 1 .3 1.2v.2h-.2l-.2-1v1h.5v1.2c.2.6.2.3.2.2v.3l-.2.4v.7c.2-.4.5.3.6 2v1.2c-.4 1.8-.6-1-.5 2.7a5 5 0 0 1-.2-3.5 10.4 10.4 0 0 1-.4-1 32 32 0 0 0-.3 6.2 10.4 10.4 0 0 1 0-1.4l.8 5.2c-.2.8-.3.2-.4-.5 0 1 .4 1.8.4 3.2-.4-.4-.7-.2-1-2.4l.2 2.4a12.2 12.2 0 0 0 0 1.3l.3.7v.8a2.4 2.4 0 0 0 0 .6l-.2 1.4c0 1 0 1.7-.2 1.2a24.4 24.4 0 0 0 0 2.7v.6h6.9l1-.2v-.4l.2.3h.3l.4.2h.3a13.6 13.6 0 0 0 1.5 0l2.8.4a8.5 8.5 0 0 1 2 .4l.2-1h.2l.5-1.2a11 11 0 0 1 .3 1.8v.2h.3l1-.2a21 21 0 0 0 2.8-.4c.2 0 0 0 0 .2l.2.3c.4 0 .5.2.5 0h-.2a.7.7 0 0 1 0-.3v-.4h.5l.5.2h1.6c3.5-.3 1.3.5 2.5.7a22.8 22.8 0 0 1 8.6-.2h-3l2.6.5c-3.3.5-5.6.2-3 .8 0-.6 2.6-.5 5.3-.5h4.2a16.3 16.3 0 0 0 2-.3 2 2 0 0 0 .5 0l-.2-.4 3-.2-.2-1.7a1 1 0 0 0 0-.4h.3l-.5-1.5a3.5 3.5 0 0 1-.2-1 7 7 0 0 1 0-.7v-2a6.5 6.5 0 0 1 0-.6c0-.4.2-.4.3.2l-.3-3.5c0-1 0-.8.2-.2v-4.8a32.3 32.3 0 0 1-.7-3.3c.2-1.3 0 .6.3.3l-.2-3c.3-1 .6 1.3.6 3.3 1.2-2.7-.3-2.4.4-8.2v2.7c.8-1.7.6-3.8 1-7-.2.8-1 6.2-1.4 3a13.8 13.8 0 0 0 0-3.6c.3 0 .2-1.6.2-3.7l.6.2a6.5 6.5 0 0 0-.2-1.2l-.2-.2a2 2 0 0 1-.4-.6.8.8 0 0 1 .2-.6 2.3 2.3 0 0 1 1 .7c.2 0 0 0 0-.2-.3 0-.5-.4.2-.4h1l.2-.5v.5h1.2v-1h4a3.5 3.5 0 0 1 1 .3l.5-1.3a2.2 2.2 0 0 1 .4.7 3.2 3.2 0 0 0 .3.7l.2-.2a3 3 0 0 1 .6-.2c.5 0 .4 0 .3.2 1.6-.2 0-.6 2.8-.8a1 1 0 0 1 .5 0l.4-.2h.4a2.6 2.6 0 0 0 .4 0l.3-.2a2.3 2.3 0 0 0 .5-.3 14.4 14.4 0 0 1 2.2-.3l2-.2 1.8-.2-.3-1.4v-.2h.3l-.2-.6a3.3 3.3 0 0 0-.2-.5 1.8 1.8 0 0 0-.3-.6l.4-3.2c-.3 2.4-1-.6-1.3-3.3l-.2.3v-1a3.7 3.7 0 0 0 0 .6.8.8 0 0 1 .2-.6l-.3-.6V325a4 4 0 0 1 .6 1.2l-.3 1.5c.4 1 .8 2 1 1.8a9 9 0 0 1 0-1.4c0 .4.2.6.3.4a4.2 4.2 0 0 0-.2-1.2l.6-1-.2-.2.4-5.5c-.4-4-1.4-7.4-1.6-13.7zm-63.2-4.5v-.2h.2v.2zm-14-11a5 5 0 0 0-.3-1l.2.4a3.3 3.3 0 0 1 0 .5zm.2 0a1 1 0 0 0 0-.4zm-.3-.7v.2l-.3-.3zm2-9.2zm-67.6 29.6l-.2.3v-.2l.3-.3zm-.6-1c0-.6 0-.8.4 0a5.7 5.7 0 0 0 0 1l-.2.2a8.8 8.8 0 0 1 0-1.2zm.2 1.6v-.2.3zm0 .3v-.3a.7.7 0 0 0 .2.4v.2a.4.4 0 0 1 0-.3zm68.4-31.6l-.3.4a.8.8 0 0 1 .2-.3zm-4.7 10.7zm0 13.5v.2a2 2 0 0 0-.2-.6h.2v.2zm17.5.5v-.2a.6.6 0 0 0 .3 0h-.3zm55.3 31.6l.2.2v-.2.2-.2zm.2 0zm0 0h-.2l-.7-.2h1zM443 283a1 1 0 0 0 0 .2zm.8-2.8a1.6 1.6 0 0 0 0-.2v.5a.6.6 0 0 1 0-.4zm-40.6 78zm.2 0zm-.4-2v-.2a1.7 1.7 0 0 1 .4 0zm0-.6h.4-.4zm.5 1.3h-.4zm0-21.5v.8a.3.3 0 0 1 0 .3l-.7-.6v-.3zM398 337zm-17.2-35v.2-.4zm.5.4zm1.4-1v.2zm-1-9l-.4.3.2-.4-.2-.2v.2zm-.7 9.5l-.2-.3zm2.3-.2l-.2.2h.2v.2h-.3v-.2zm-.6-14c.2.2.3.2 0 .2zm0 0h-.4.3zm-.3 13.7v.2h-.2v-.2zm0 .3v.2zm0 .2l.2-.3h.2a2.3 2.3 0 0 1 0 .3 1.2 1.2 0 0 0 0-.3 1 1 0 0 1 0 .2h-.2zm-3.8 1.4l.2.2-.2-.2-.2-.2zm1.4-1.8c0 .2.2.6 0 0zm0 0v-.2.2zm-1.2 2h-.2zm1.5-.4v-.4l.2.3a1.8 1.8 0 0 0-.2.3zm2.2-.7zm-4 .8zm.2.4zm-.2 0a2.5 2.5 0 0 1-.4-.3h.3v-.2l.2.2zm-.4 0v-.2zm.4-.6zm0 .2l.2.2-.2-.2-.2-.2zm.5.4zm-.4-.3v-.2h-.2zm0-.2v.3zm-.6-.2zm-.5 0zm-.8-1h.2zm.5 0v.2zm.2 0zm-.2 0l-.2-.2v-.2zm0 0h.2zm.3 0l-.2-.2zm-.3-.3zm0 .2v-.2zm-.6.2v-.2zm.6-.3h-.2zm0-.3h-.2v-.2.2zm-.3 1.2h-.2.4-.3zm.4-.2zm0 0v.2zm0 .2zm-.3 0h.4-.2zm.7 0v.2zm0 0v.2zm-.5.5v.2zm0 0h.2zm.2 0v-.2h.2zm.3 0v-.2l.2.2-.3-.2.2.2-.2-.2v.2l.2.2v-.2.2h.2zm0 0v-.3s.4.4 0 0l.3.3v-.2zm.4.2zm0 0zm0 0v-.2zm0-.3l-.2-.2zm-.2-.2v.2zm0 0zm0-.2zm0 0v.2zm-.4.5a2.7 2.7 0 0 0 .4.4h-.4zm.5.3zm0 0zm0 0h-.2v-.2h-.2c0 .2 0 0 0 0v.2-.2h-.2v-.2l.2.3-.3-.3.2.2-.2-.3v.3l.2.2zm-.3-.4zm1.8-.8zm1.5.2v-.2a.2.2 0 0 1 0 .3v-.3.2zm0-.2c.2.2.2.2.2 0zm0 0zm0 1a.4.4 0 0 0 .2 0zm.5-1.3h.3zm-.2 0v.2zm-1.8 0v.2zm-1.6 1h-.2v.2-.2l.2.2zm-.5-.4zm-4.4-.3h.3zm9 .6a.6.6 0 0 0-.2 0 2.4 2.4 0 0 0 .4-.3v.2zm-.6-1v-.2zm-1.8.4v.2zm-1.5 1.2zm-.3-.7a2.7 2.7 0 0 0 .4-.3v.4zm0-.4l.2-.2v-.2.4zm-4.7 0a2 2 0 0 0 .2.3 1.7 1.7 0 0 0 0-.3zm8.4-.4v-.2a1.6 1.6 0 0 1 0 .2zm-2-.4l-.3-.4.3.3zm-.3-.3l.2.3v-.2zm-.8 2h-.5v-.7l.3.4-.2-.3v-.2h.5l.4.2-.4.3h.2zm-.2-.5v-.5.4zm.3-1.3v.2a2 2 0 0 1-.3.2v-.2a3.3 3.3 0 0 0 .2-.3zm-5.5 1.5a.2.2 0 0 0-.2 0 2 2 0 0 1 .2-.4h.2v.2zm8.5-1.6v-.2zm-2.2-.4l.2.2v.2-.3zm.2.4v-.2.2-.3.5-.6zm0 .3v.2l-.8.6v-.6l.5-.4.2-.5zm-1.3-1.4zm0 0zm1.8-8.5h.2zm-1.4 8.7h-.2v-.2zm1.8-9l-.4.2.3-.3zm.2 10v.2zm-.5 0l-.2-.2zm-.5-.6zm0 0v.2-.4zm-.3-.6l-.2.3a.2.2 0 0 1-.2 0v-.3zm7.4-21l.3.3zm0 0h.2a.4.4 0 0 1 .5.2h-.4zm1-1.4zm9 57.7a2.7 2.7 0 0 0-.4.5 2.4 2.4 0 0 1 .2-.4zm-.4.6a2.7 2.7 0 0 0-.2.6 2.7 2.7 0 0 1 0-.6zm42.6 39.6v-.4zm0 0v-1l-.2-.2v.2l.2.2.3 1zm4-97.8v.2-.2zm-1.4 0h-.3v-.2a1.2 1.2 0 0 0 .4.4zm-40 11.4h-.2zm-1 6.5c.2 0 .6.5.7 1.3a2 2 0 0 0-.6 0 9 9 0 0 0 0-1.4zm.3 3.4zm0 0v.2zm.2.3h.2zm-1 3l1-.5a1.6 1.6 0 0 0 0 .4l-.8.3.7-.4v.2a.7.7 0 0 0 0-.3h.2l-.6.4.8-.5.5-.3a2 2 0 0 0 .3-.2l.2.3v.7s0-.2-.3 0 0-.3-.2-.3h-1.4.3-.4a.3.3 0 0 1 0-.4zm-16.3.5a2 2 0 0 0 0-1 .3.3 0 0 1 .2-.2v.2a2.5 2.5 0 0 1-.2 1zm0-1.5a2.2 2.2 0 0 0-.7-.8 1.7 1.7 0 0 1 0-.3 1.2 1.2 0 0 0 0 .2h-.2v-.2l.3.2a2.6 2.6 0 0 1 1 1.2zm-1-1.3v.3zm-.2-.2l.3.2v.4h-.5l.2-.3v.2-.5zm-1.2.8zm0 0a.7.7 0 0 0 0 .2zm-.4-.3v.4zm0 .6h-.2zm0-.5zm0 1l.2-.2v.5a.5.5 0 0 0 0 .2v-.5.7h-.2v-.7h.3v.4zm-.6-.3zm-1.7-1a2.3 2.3 0 0 1 .4 0h-.5v-.2zm.2-2.2h.2zm2.7-3.6v.2zm3.6-5.5zm-.4-.6h-.7.7zm2.3-6.8a.8.8 0 0 1 0 .6l-.4-.3a1 1 0 0 0 .2-.3h.4-.2zm1-1h-.2l.3-.2a1 1 0 0 1 0 .3zm.4-.3h-.3v-.4a1.5 1.5 0 0 1 .2.6zm.3-1.7l.3-.4-.3.3.3-.4zm-59.4 15s.2 0 0 0zm-.2 0h-.4.5zm0 .2a1.8 1.8 0 0 1 0 .2zm-5.5 7v.2a3 3 0 0 1 .8 1l-1.3-.6zm-4.4 20.7c0 2.5.5-.8.5 1.8v.8l.3.7a10.6 10.6 0 0 1 0 1.5l-.6.6v-1 .2-4.5zm0 5.7l.3-.2zm47.6 8.6l-.5-.2a4.7 4.7 0 0 1 .6 0s.2 0 0 0 0 .2 0 .2zm5 .4h.2zm24.8 2a3 3 0 0 0 0 .3 2.4 2.4 0 0 1 0-.5zm43.2 39h.4v.2h-.3.2-.2v-.2zm3.5-28.5a7.8 7.8 0 0 1 0 2.7c-.4-1-.2-1.6 0-3zm2.6-10.7zm1.2.2h-.2s0 .2-.2 0l-.3-.6V336.8l.6 1v.2zm0-2l.3.2-.2.4zM465 323a13.8 13.8 0 0 1 0-2.4 6.6 6.6 0 0 1 0 2.4z"
                                class="moko-404__f" />
                            <path
                                d="M116.7 377.8s2.7-3.4 2.2-6.7c0 0 1.8 4 5 1.7s3.3-4 3.3-4 1 5 4 5c2.5.4 4-.7 5.3-4.8 0 0 0 4.2 3.2 3.5 2.5-.5 3.3-5.3 3.3-5.3s1.8 5.2 3 5c0 0 1.5 1.2 2-2 0 0 0 3.2 4.2 2.6s3.8-2.6 3.8-2.6 0 3.4 2.6 3.3 3.5-3.3 3.5-3.3 1 4.8.5 6.6M439 382s-3-3-2.5-5.7a4 4 0 0 1-5.3 1.6l-.2-.2c-3.5-2-3.3-3.4-3.3-3.4s-1 4.2-4.3 4.4c-2.6 0-4.3-.7-5.5-4.2 0 0 0 3.6-3.5 3-2.6-.4-3.5-4.5-3.5-4.5s-1.8 4.5-3 4.4c0 0-1.7 1-2.3-1.8 0 0 0 2.8-4.4 2.3s-4-2.3-4-2.3 0 3-2.8 2.8a4.4 4.4 0 0 1-3.8-2.8s-1 4-.4 5.6M271.4 382s-3-3-2.3-5.8a4 4 0 0 1-5.3 1.4c-3.6-2-3.5-3.4-3.5-3.4s-1 4.2-4.3 4.4c-2.7.2-4.4-.7-5.6-4.2 0 0 0 3.7-3.4 3-2.6-.3-3.5-4.4-3.5-4.4s-1.7 4.4-3 4.2c0 0-1.6 1-2.3-1.8 0 0 0 2.8-4.4 2.3s-4-2.2-4-2.2 0 3-2.8 2.8a4.4 4.4 0 0 1-3.7-2.8s-1 4-.4 5.6"
                                class="moko-404__d" />

                            <path class="leafO1 moko-404__j"
                                d="M50.17,255.75s-14.62-11.54-9.89-35.36C40.27,220.39,57.9,233.78,50.17,255.75Z" />
                            <path class="stemO1 moko-404__f"
                                d="M51.86,264.27s-7-28.29-6.13-29.09,7.56,28.39,7.56,28.39" />
                            <path class="leafN1 moko-404__j"
                                d="M316.78,81.48s-20-28.31,1-68.33C317.75,13.15,342.16,46.34,316.78,81.48Z" />
                            <path class="stemN1 moko-404__g"
                                d="M315.31,97.59s2.44-54.18,4.39-55.15-1.46,54.67-1.46,54.67" />
                            <path class="leafM1 moko-404__j"
                                d="M331.6,72.71s4.85-29.48,29.34-37.41C360.94,35.3,354.86,65.06,331.6,72.71Z" />
                            <path class="stemM1 moko-404__g"
                                d="M328.61,77.53s16-27.89,20.9-29.1C349.5,48.43,331.11,77.05,328.61,77.53Z" />
                            <path class="leafL1 moko-404__g"
                                d="M182.91,190.61c1.13.33,2-12.55-12.46-18.18C170.45,172.43,169.29,186.61,182.91,190.61Z" />
                            <path class="stemL1 moko-404__f"
                                d="M184.15,193s-10.1-13.39-9.87-13.84,10.6,13.38,10.6,13.38" />
                            <path class="leafK1 moko-404__j"
                                d="M52.09,256.5c-.14,1.32,14.4-.31,17.68-17.63C69.77,238.87,53.74,240.51,52.09,256.5Z" />
                            <path class="stemK1 moko-404__f"
                                d="M51.64,256.37s10.85-12,11.4-11.84S52.3,257.09,52.3,257.09" />
                            <path class="leafJ1 moko-404__j"
                                d="M345.32,250.15s15.19-15.25,6.5-41.94C351.82,208.21,333.43,226,345.32,250.15Z" />
                            <path class="stemJ1 moko-404__f"
                                d="M344.54,260.16s4.13-33.43,3-34.23-4.78,33.62-4.78,33.62" />
                            <path class="leafI1 moko-404__j"
                                d="M343.21,251.28c.34,1.5-16.57,1.62-22.71-17.8C320.5,233.47,339.12,233.15,343.21,251.28Z" />
                            <path class="stemI1 moko-404__f" d="M343.71,251.07s-14.1-12.29-14.71-12S343,252,343,252" />
                            <path class="leafH1 moko-404__g"
                                d="M369,234.34s-8.11-15.62,2.67-25.83C371.64,208.51,381.09,218.73,369,234.34Z" />
                            <path class="leafG1 moko-404__m"
                                d="M155.38,251.29c-.07,1.28,13.85-.92,16.27-17.73C171.65,233.56,156.29,235.83,155.38,251.29Z" />
                            <path class="stemG1 moko-404__g"
                                d="M150,257.08s14.88-18,15.36-17.78c.88.49-13.85,18.78-13.85,18.78" />
                            <path class="leafF1 moko-404__m"
                                d="M100.49,197.69c1,1.14,10.91-12-.74-28.18C99.75,169.52,88.66,183.94,100.49,197.69Z" />
                            <path class="stemF1 moko-404__g"
                                d="M100.71,206.91s-2.16-27.31-1.54-27.48c1.14-.3,3.63,27.1,3.63,27.1" />
                            <path class="leafE1 moko-404__m"
                                d="M416.83,181.15c1.11.48,3.64-12.58-10.5-20.13C406.33,161,403.4,175.38,416.83,181.15Z" />
                            <path class="stemE1 moko-404__g"
                                d="M420.25,187.75s-11.22-19-10.83-19.34c.72-.62,12.21,18.33,12.21,18.33" />
                            <path class="leafD1 moko-404__m"
                                d="M254.58,327c-.49,1.11-11.21-6.76-6-21.9C248.62,305.14,260.52,313.69,254.58,327Z" />
                            <path class="stemD1 moko-404__g"
                                d="M256.55,334.2s-4.67-21.57-5.18-21.55c-.95,0,3.48,21.74,3.48,21.74" />
                            <path class="leafC1 moko-404__f"
                                d="M31.65,304c.78.43,3.56-9-6.29-15.53C25.37,288.44,22.2,298.78,31.65,304Z" />
                            <path class="stemC1 moko-404__g"
                                d="M33.7,309.06s-6.9-14.75-6.59-15c.57-.41,7.67,14.33,7.67,14.33" />
                            <path class="leafB1 moko-404__f"
                                d="M463.8,301.91c.38.81,8.14-5.21,4-16.27C467.77,285.64,459.16,292.18,463.8,301.91Z" />
                            <path class="stemB1 moko-404__g"
                                d="M462.49,307.24s3-16,3.4-16c.7,0-2.14,16.11-2.14,16.11" />
                            <path class="leafA1 moko-404__f"
                                d="M448.21,277.22c-.07,1.17,12.66-.84,14.87-16.2C463.07,261,449,263.08,448.21,277.22Z" />
                            <path class="stemA1 moko-404__g"
                                d="M443.33,282.5s13.6-16.49,14-16.25c.8.45-12.66,17.17-12.66,17.17" />

                            <path class="leafO2 moko-404__j"
                                d="M49.29,255.07S33,246,33.93,221.71C33.93,221.71,53.45,232.15,49.29,255.07Z" />
                            <path class="stemO2 moko-404__f"
                                d="M52.31,263.22s-11.37-26.83-10.65-27.76,12,26.84,12,26.84" />
                            <path class="leafN2 moko-404__j"
                                d="M315.63,81.49s-23-26-6.48-68C309.15,13.46,337,43.79,315.63,81.49Z" />
                            <path class="stemN2 moko-404__g"
                                d="M315.93,97.66s-3.48-54.12-1.65-55.3,4.5,54.5,4.5,54.5" />
                            <path class="leafM2 moko-404__j"
                                d="M331,73.09S332.55,43.25,356,32.62C356,32.62,353.29,62.87,331,73.09Z" />
                            <path class="stemM2 moko-404__g"
                                d="M328.61,78.21s12.81-29.52,17.5-31.26C346.1,46.95,331,77.46,328.61,78.21Z" />
                            <path class="leafL2 moko-404__g"
                                d="M183,189.39c1,.66,5.8-11.31-6.28-21.13C176.75,168.27,171.3,181.4,183,189.39Z" />
                            <path class="stemL2 moko-404__f" d="M183.47,192.07s-5.5-15.85-5.14-16.2,6,16,6,16" />
                            <path class="leafK2 moko-404__j"
                                d="M52.44,257.67c.06,1.33,14.2-2.42,14.9-20C67.34,237.64,51.72,241.61,52.44,257.67Z" />
                            <path class="stemK2 moko-404__f" d="M52,257.61s9-13.47,9.54-13.38-8.78,14-8.78,14" />
                            <path class="leafJ2 moko-404__j"
                                d="M344.81,250.2s14.72-15.71,5.23-42.12C350,208.08,332.19,226.41,344.81,250.2Z" />
                            <path class="stemJ2 moko-404__f"
                                d="M344.34,260.23s3.12-33.54,2-34.3-3.76,33.75-3.76,33.75" />
                            <path class="leafI2 moko-404__j"
                                d="M343.49,251.73c0,1.54-16.54-1.89-18.48-22.17C325,229.56,343.29,233.15,343.49,251.73Z" />
                            <path class="stemI2 moko-404__f" d="M344,251.63s-11.22-15-11.86-14.84,11,15.6,11,15.6" />
                            <path class="leafH2 moko-404__g"
                                d="M369.32,234.28s-12.16-12.72-4.66-25.55C364.66,208.73,376.59,215.9,369.32,234.28Z" />
                            <path class="leafG2 moko-404__m"
                                d="M157.69,250.71c-.27,1.25,13.82,1.24,18.81-15C176.5,235.71,161,235.57,157.69,250.71Z" />
                            <path class="stemG2 moko-404__g"
                                d="M151.52,255.61s17.5-15.53,17.93-15.19c.79.62-16.59,16.42-16.59,16.42" />
                            <path class="leafF2 moko-404__m"
                                d="M99.61,198.37c1.21.89,7.93-14.19-7-27.29C92.56,171.08,85,187.62,99.61,198.37Z" />
                            <path class="stemF2 moko-404__g"
                                d="M101.89,207.31s-8.24-26.13-7.67-26.43c1-.55,9.62,25.59,9.62,25.59" />
                            <path class="leafE2 moko-404__m"
                                d="M415.95,181.54c1.18.28,1.41-13-13.82-18C402.13,163.53,401.72,178.18,415.95,181.54Z" />
                            <path class="stemE2 moko-404__g"
                                d="M420.46,187.44s-14.34-16.78-14-17.18c.6-.74,15.2,15.94,15.2,15.94" />
                            <path class="leafD2 moko-404__m"
                                d="M253.48,326.64c-.35,1.16-12-5.29-8.68-21C244.8,305.67,257.68,312.64,253.48,326.64Z" />
                            <path class="stemD2 moko-404__g"
                                d="M256.34,333.49s-7.35-20.8-7.87-20.72c-.94.15,6.2,21.12,6.2,21.12" />
                            <path class="leafC2 moko-404__f"
                                d="M30.73,305.66c.89,0-.67-9.64-12.39-11.28C18.35,294.38,20,305.07,30.73,305.66Z" />
                            <path class="stemC2 moko-404__g"
                                d="M34.78,309.36S22.17,299,22.36,298.71c.34-.61,13.11,9.6,13.11,9.6" />
                            <path class="leafB2 moko-404__f"
                                d="M463.63,302.34c.19.87,9.1-3.24,7.53-15C471.16,287.38,461.3,291.81,463.63,302.34Z" />
                            <path class="stemB2 moko-404__g"
                                d="M461.16,307.23s6.54-14.91,6.91-14.83c.68.16-5.71,15.21-5.71,15.21" />
                            <path class="leafA2 moko-404__f"
                                d="M447.56,278.48c-.23,1.15,12.65.92,17-14C464.53,264.48,450.33,264.59,447.56,278.48Z" />
                            <path class="stemA2 moko-404__g"
                                d="M442,283s15.75-14.46,16.15-14.15c.73.55-14.91,15.26-14.91,15.26" />
                        </svg>
                    </div>
                    <div class="align-items-center d-flex flex-column gap-3">
                        <h1 class="animate-text">{{ localize('Page Not Found') }}</h1>
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-primary w-max-content py-2 lh-lg">Go to Dashboard</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- jQuery and Bootstrap Bundle (includes Popper) -->
    <script src="{{ assets('vendor/jQuery/jquery.min.js') }}"></script>
    <script src="{{ assets('vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
</body>

</html>
