<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'first_name' => $this->first_name ?? null,
            'last_name'  => $this->last_name ?? null,
            'username'   => $this->last_name ?? null,
            'avatar'     => $this->avatar ?? null,
        ];

        return $data;
    }
}